/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.ElasticsearchClientFactory;
import com.thebeastshop.pegasus.merchandise.vo.PsCustomizeColorVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCustomizeElementVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCustomizeImageVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCustomizeVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsTagVO;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuESClient
extends AbstractESClient<PsSkuVO> {
    private static final Logger log = LoggerFactory.getLogger(SkuESClient.class);

    public SkuESClient(String index, String type, ElasticsearchClientFactory elasticsearchClientFactory) {
        super(index, type, elasticsearchClientFactory);
    }

    @Override
    public PsSkuVO build(SearchHit hit, String chnCode) {
        return this.build(hit, chnCode, null);
    }

    @Override
    public PsSkuVO build(SearchHit hit, String chnCode, Long total) {
        PsSkuVO vo = new PsSkuVO();
        try {
            Map params = hit.getSource();
            vo.setSkuId(Long.valueOf((long)((Integer)params.get("skuId")).intValue() + 0L));
            vo.setSkuCode((String)params.get("skuCode"));
            vo.setSkuName((String)params.get("skuName"));
            vo.setSkuNameCN((String)params.get("skuNameCN"));
            vo.setSkuType((Integer)params.get("skuType"));
            vo.setIsMadeBySelf((Integer)params.get("isMadeBySelf"));
            vo.setIsImported((Integer)params.get("isImported"));
            vo.setSkuCustomMadeCode((String)params.get("customMadeCode"));
            vo.setCombinedSkuRecipeCode((String)params.get("combinedSkuRecipeCode"));
            vo.setEan13((String)params.get("ean13"));
            vo.setBarcode((String)params.get("barcode"));
            vo.setCanPurchase((Integer)params.get("canPurchase"));
            vo.setCanRemark((Integer)params.get("canRemark"));
            vo.setIsJit((Integer)params.get("isJit"));
            vo.setSalesPrice(Double.valueOf(MapUtils.getDoubleValue((Map)params, (Object)"salesPrice")));
            vo.setCategoryId(Long.valueOf((long)((Integer)params.get("categoryId")).intValue() + 0L));
            vo.setCategoryName((String)params.get("categoryName"));
            vo.setBrandId(Long.valueOf(MapUtils.getLongValue((Map)params, (Object)"brandId")));
            vo.setBrandName((String)params.get("brandName"));
            vo.setBrandNameCN((String)params.get("brandNameCN"));
            if (params.get("canCustomizeSalesPrice") != null) {
                vo.setCanCustomizeSalesPrice((Integer)params.get("canCustomizeSalesPrice"));
            }
            if (params.get("saleEndDate") != null) {
                String text = params.get("saleEndDate").toString();
                vo.setSaleEndDate(this.utcToDate(text));
            }
            if (params.get("skuStatus") != null) {
                vo.setSkuStatus((Integer)params.get("skuStatus"));
            }
            if (params.get("brandCountryId") != null) {
                vo.setBrandCountryId(Long.valueOf((long)((Integer)params.get("brandCountryId")).intValue() + 0L));
            }
            if (params.get("brandCountryName") != null) {
                vo.setBrandCountryName((String)params.get("brandCountryName"));
            }
            vo.setCanCustomize(MapUtils.getInteger((Map)params, (Object)"canCustomize"));
            if (vo.getCanCustomize() != null && vo.getCanCustomize() == 1) {
                PsCustomizeElementVO customizationVO;
                if (MapUtils.getString((Map)params, (Object)"customizationPrice") == null) {
                    vo.setCustomizationPrice(new BigDecimal(0L));
                } else {
                    vo.setCustomizationPrice(new BigDecimal(MapUtils.getString((Map)params, (Object)"customizationPrice")));
                }
                Map customize = (Map)params.get("customize");
                List colorElementMapList = (List)customize.get("colorElementList");
                List wordElementMapList = (List)customize.get("wordElementList");
                List customizeImageMapList = (List)customize.get("customizeImageList");
                ArrayList<PsCustomizeElementVO> colorElements = new ArrayList<PsCustomizeElementVO>();
                ArrayList<PsCustomizeElementVO> wordElements = new ArrayList<PsCustomizeElementVO>();
                ArrayList<PsCustomizeElementVO> customizeImages = new ArrayList<PsCustomizeElementVO>();
                PsCustomizeVO customizeVO = new PsCustomizeVO();
                if (CollectionUtils.isNotEmpty((Collection)colorElementMapList)) {
                    for (Map colorElementMap : colorElementMapList) {
                        customizationVO = new PsCustomizeElementVO();
                        customizationVO.setId(MapUtils.getLong((Map)colorElementMap, (Object)"id"));
                        customizationVO.setDisplayName(MapUtils.getString((Map)colorElementMap, (Object)"displayName"));
                        customizationVO.setPositionIcon(MapUtils.getString((Map)colorElementMap, (Object)"positionIcon"));
                        customizationVO.setElementType(MapUtils.getInteger((Map)colorElementMap, (Object)"elementType"));
                        customizationVO.setBgColor(Boolean.valueOf(MapUtils.getBoolean((Map)colorElementMap, (Object)"bgColor") == null ? false : MapUtils.getBoolean((Map)colorElementMap, (Object)"bgColor")));
                        String color = MapUtils.getString((Map)colorElementMap, (Object)"color");
                        customizationVO.setColor(color);
                        ArrayList<PsCustomizeColorVO> colorVOs = new ArrayList<PsCustomizeColorVO>();
                        List listObj = (List)JSON.parseObject((String)color, List.class);
                        if (CollectionUtils.isNotEmpty((Collection)listObj)) {
                            for (List listVO : listObj) {
                                int colorSize = listVO.size();
                                PsCustomizeColorVO colorVO = new PsCustomizeColorVO();
                                colorVO.setColorName((String)listVO.get(0));
                                colorVO.setColorValue((String)listVO.get(1));
                                if (colorSize > 2) {
                                    colorVO.setBackgroundColorValue((String)listVO.get(2));
                                    colorVO.setWordColorValue((String)listVO.get(3));
                                }
                                colorVOs.add(colorVO);
                            }
                        }
                        customizationVO.setColorList(colorVOs);
                        customizationVO.setIsmatch(MapUtils.getBoolean((Map)colorElementMap, (Object)"ismatch"));
                        customizationVO.setParentId(MapUtils.getInteger((Map)colorElementMap, (Object)"parentId"));
                        colorElements.add(customizationVO);
                    }
                    customizeVO.setColorElementList(colorElements);
                }
                if (CollectionUtils.isNotEmpty((Collection)wordElementMapList)) {
                    for (Map wordElementMap : wordElementMapList) {
                        customizationVO = new PsCustomizeElementVO();
                        customizationVO.setId(MapUtils.getLong((Map)wordElementMap, (Object)"id"));
                        customizationVO.setDisplayName(MapUtils.getString((Map)wordElementMap, (Object)"displayName"));
                        customizationVO.setPositionIcon(MapUtils.getString((Map)wordElementMap, (Object)"positionIcon"));
                        customizationVO.setElementType(MapUtils.getInteger((Map)wordElementMap, (Object)"elementType"));
                        customizationVO.setColor(MapUtils.getString((Map)wordElementMap, (Object)"color"));
                        customizationVO.setWordsLimit(MapUtils.getInteger((Map)wordElementMap, (Object)"wordsLimit"));
                        customizationVO.setSupportType(MapUtils.getString((Map)wordElementMap, (Object)"supportType"));
                        customizationVO.setIsmatch(MapUtils.getBoolean((Map)wordElementMap, (Object)"ismatch"));
                        customizationVO.setParentId(MapUtils.getInteger((Map)wordElementMap, (Object)"parentId"));
                        Map colorElement = (Map)wordElementMap.get("colorElement");
                        if (colorElement != null && colorElement.size() > 0) {
                            Integer ismatch;
                            PsCustomizeElementVO colorElementVO = new PsCustomizeElementVO();
                            Integer id = (Integer)colorElement.get("id");
                            colorElementVO.setId(Long.valueOf(id.longValue()));
                            colorElementVO.setElementType((Integer)colorElement.get("elementType"));
                            colorElementVO.setPositionIcon((String)colorElement.get("positionIcon"));
                            colorElementVO.setDisplayName((String)colorElement.get("displayName"));
                            if (colorElement.get("parentId") != null) {
                                colorElementVO.setParentId((Integer)colorElement.get("parentId"));
                            }
                            colorElementVO.setIsmatch(Boolean.valueOf(1 == (ismatch = (Integer)colorElement.get("ismatch"))));
                            String color = (String)colorElement.get("color");
                            colorElementVO.setColor(color);
                            ArrayList<PsCustomizeColorVO> colorVOs = new ArrayList<PsCustomizeColorVO>();
                            List ListObj = (List)JSON.parseObject((String)color, List.class);
                            if (CollectionUtils.isNotEmpty((Collection)ListObj)) {
                                for (List listVO : ListObj) {
                                    PsCustomizeColorVO colorVO = new PsCustomizeColorVO();
                                    colorVO.setColorName((String)listVO.get(0));
                                    colorVO.setColorValue((String)listVO.get(1));
                                    colorVOs.add(colorVO);
                                }
                            }
                            colorElementVO.setColorList(colorVOs);
                            customizationVO.setColorElement(colorElementVO);
                        }
                        wordElements.add(customizationVO);
                    }
                    customizeVO.setWordElementList(wordElements);
                }
                if (CollectionUtils.isNotEmpty((Collection)customizeImageMapList)) {
                    for (Map customizeImageMap : customizeImageMapList) {
                        customizationVO = new PsCustomizeImageVO();
                        customizationVO.setId(MapUtils.getLong((Map)customizeImageMap, (Object)"id"));
                        customizationVO.setImageUrl(MapUtils.getString((Map)customizeImageMap, (Object)"imageUrl"));
                        String attr = MapUtils.getString((Map)customizeImageMap, (Object)"attr");
                        customizationVO.setAttr(attr);
                        List attrs = (List)JSON.parseObject((String)attr, List.class);
                        customizationVO.setAttrs(attrs);
                        customizeImages.add(customizationVO);
                    }
                    customizeVO.setCustomizeImageList(customizeImages);
                }
                vo.setCustomize(customizeVO);
            }
            vo.setSupplierId(Long.valueOf((long)((Integer)params.get("supplierId")).intValue() + 0L));
            vo.setSupplierName((String)params.get("supplierName"));
            vo.setSupplierNameCN((String)params.get("supplierNameCN"));
            vo.setPlaceOfOrigin((String)params.get("placeOfOrigin"));
            vo.setSkuCateName((String)params.get("skuCategoryName"));
            vo.setPointDeductPoint(new BigDecimal(MapUtils.getString((Map)params, (Object)"pointDeductPoint")).setScale(2, 1));
            vo.setPointDeductRule((Integer)params.get("pointDeductRule"));
            vo.setPointDuductPrice(new BigDecimal(MapUtils.getString((Map)params, (Object)"pointDuductPrice")).setScale(2, 1));
            vo.setCostPrice(new BigDecimal(MapUtils.getString((Map)params, (Object)"costPrice")).setScale(2, 1));
            vo.setCrossBorderFlag((Integer)params.get("crossBorderFlag"));
            if (params.get("clearanceWay") != null) {
                Integer bd = (Integer)params.get("clearanceWay");
                String db = "" + bd;
                vo.setClearanceWay(Short.valueOf(db));
            }
            vo.setWeight((String)params.get("weight"));
            vo.setTaxNo((String)params.get("taxNo"));
            vo.setUpdateTime((String)params.get("updateTime"));
            vo.setWhetherConsignment((Integer)params.get("whetherConsignment"));
            vo.setIsMonthSend((Integer)params.get("isMonthSend"));
            vo.setDeliveryTimes((Integer)params.get("deliveryTimes"));
            vo.setMonthSendDeliveryRule((Integer)params.get("monthSendDeliveryRule"));
            if (params.get("deliveryPeriod") != null) {
                vo.setDeliveryPeriod((Integer)params.get("deliveryPeriod"));
            }
        }
        catch (Exception ex) {
            log.error("Build SKU Error: ", (Throwable)ex);
            throw ex;
        }
        return vo;
    }

    private List<PsTagVO> makeTagList(List<Map<String, String>> list) {
        ArrayList<PsTagVO> results = new ArrayList<PsTagVO>();
        int i = 0;
        while (i < list.size()) {
            Map<String, String> map = list.get(i);
            String icon = map.get("icon");
            String text = map.get("text");
            PsTagVO tagVO = new PsTagVO();
            tagVO.setIcon(icon);
            tagVO.setText(text);
            results.add(tagVO);
            ++i;
        }
        return results;
    }

    private List<Map<String, String>> makeTagMapList(List<PsTagVO> voList) {
        if (voList == null || voList.isEmpty()) {
            return ListUtils.EMPTY_LIST;
        }
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < voList.size()) {
            PsTagVO vo = voList.get(i);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("icon", vo.getIcon());
            map.put("text", vo.getText());
            mapList.add(map);
            ++i;
        }
        return mapList;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsSkuVO vo) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject().field("id", vo.getSkuCode()).field("skuId", vo.getSkuId()).field("skuCode", vo.getSkuCode()).field("skuName", vo.getSkuName()).field("skuNameCN", vo.getSkuNameCN()).field("skuType", vo.getSkuType()).field("isMadeBySelf", vo.getIsMadeBySelf()).field("isImported", vo.getIsImported()).field("skuCustomMadeCode", this.avoidNull(vo.getSkuCustomMadeCode())).field("combinedSkuRecipeCode", this.avoidNull(vo.getCombinedSkuRecipeCode())).field("isSkuCustomMade", vo.getIsSkuCustomMade()).field("isCombinedSkuRecipeCode", vo.getIsCombinedSkuRecipeCode()).field("ean13", this.avoidNull(vo.getEan13())).field("barcode", this.avoidNull(vo.getBarcode())).field("canPurchase", vo.getCanPurchase()).field("salesPrice", vo.getSalesPrice()).field("categoryId", (Object)NumberUtil.avoidNull((Number)vo.getCategoryId())).field("categoryName", this.avoidNull(vo.getCategoryName())).field("brandId", (Object)NumberUtil.avoidNull((Number)vo.getBrandId())).field("brandName", vo.getBrandName()).field("brandNameCN", vo.getBrandNameCN()).field("brandCountryId", vo.getBrandCountryId()).field("brandCountryName", vo.getBrandCountryName()).field("skuCategoryName", vo.getSkuCateName()).field("canRemark", vo.getCanRemark()).field("placeOfOrigin", vo.getPlaceOfOrigin()).field("isJit", vo.getIsJit()).field("supplierId", (Object)NumberUtil.avoidNull((Number)vo.getSupplierId())).field("supplierName", this.avoidNull(vo.getSupplierName())).field("supplierNameCN", this.avoidNull(vo.getSupplierNameCN())).field("pointDeductPoint", vo.getPointDeductPoint()).field("pointDeductRule", vo.getPointDeductRule()).field("pointDuductPrice", vo.getPointDuductPrice()).field("costPrice", vo.getCostPrice()).field("updateTime", vo.getUpdateTime()).field("crossBorderFlag", vo.getCrossBorderFlag()).field("clearanceWay", (Object)vo.getClearanceWay()).field("weight", vo.getWeight()).field("taxNo", vo.getTaxNo()).endObject();
            return builder;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String avoidNull(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getPrimaryKeyName() {
        return "skuCode";
    }

    private Date utcToDate(String s) {
        s = s.replace('T', ' ');
        s = s.replace("Z", "");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = df.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, 8);
        date = calendar.getTime();
        return date;
    }
}

