package com.thebeastshop.pegasus.merchandise.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.merchandise.cond.OpProdSkuAttributeInfoCond;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeLineMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeRelationMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuAttributeDomain;
import com.thebeastshop.pegasus.merchandise.enums.OpProdSkuAttributeLineStatusEnum;
import com.thebeastshop.pegasus.merchandise.enums.OpProdSkuAttributeStatusEnum;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.exception.OperationExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttribute;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeLine;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeRelation;
import com.thebeastshop.pegasus.merchandise.service.OpProdSkuAttributeService;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeLineInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeRelationInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeRelationVO;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

@Service("opProdSkuAttributeService")
public class OpProdSkuAttributeServiceImpl implements OpProdSkuAttributeService {

	@Autowired
	private OpProdSkuAttributeDomain opProdSkuAttributeDomain;
	
	@Autowired
	private OpProdSkuAttributeRelationMapper opProdSkuAttributeRelationMapper;
	
	@Autowired
	private OpProdSkuAttributeMapper opProdSkuAttributeMapper;
	
	@Autowired
	private OpProdSkuAttributeLineMapper opProdSkuAttributeLineMapper;
	
	@Override
	@Transactional
	public int addOrUpdateProdSkuAttribute(OpProdSkuAttributeInfo opProdSkuAttributeInfo) {
		OpProdSkuAttribute opProdSkuAttribute = new OpProdSkuAttribute();
		BeanUtils.copyProperties(opProdSkuAttributeInfo, opProdSkuAttribute);
		Integer attributeId = opProdSkuAttribute.getId();
		List<OpProdSkuAttributeLineInfo> newLines = opProdSkuAttributeInfo.getLineList();
		if(attributeId == null) {
			opProdSkuAttribute.setGmtCreate(new Date());
			opProdSkuAttributeDomain.saveOpProdSkuAttribute(opProdSkuAttribute);
			attributeId = opProdSkuAttribute.getId();
			opProdSkuAttribute.setAttributeCode(generateCode(attributeId));
			opProdSkuAttributeDomain.saveOpProdSkuAttribute(opProdSkuAttribute);
		} else {
			//删除属性值
			List<OpProdSkuAttributeLine> oldLines = opProdSkuAttributeDomain.findLineByAttributeId(attributeId);
			opProdSkuAttributeDomain.deleteByLineIds(findDeleteLines(newLines, oldLines));
			opProdSkuAttributeDomain.saveOpProdSkuAttribute(opProdSkuAttribute);
		}
		opProdSkuAttributeDomain.saveOpProdSkuAttributeLine(convertLineInfo2DO(opProdSkuAttributeInfo.getLineList(), 
				attributeId, opProdSkuAttributeInfo.getCategoryId()));
		return 1;
	}

	/**
	 * 定位到那些属性值被删掉
	 * @param newLines
	 * @param oldLines
	 * @return
	 */
	private List<Integer> findDeleteLines(List<OpProdSkuAttributeLineInfo> newLines, List<OpProdSkuAttributeLine> oldLines) {
		List<Integer> lineIdList = new ArrayList<Integer>();
		for(OpProdSkuAttributeLine oldLine : oldLines) {
			Integer oldLineId = oldLine.getId();
			boolean isDel = true;
			for(OpProdSkuAttributeLineInfo newLine : newLines) {
				//没有删除
				if(oldLineId.equals(newLine.getId())) {
					isDel = false;
					break;
				}
			}
			if(isDel) {
				lineIdList.add(oldLineId);
			}
			
		}
		return lineIdList;
	}
	private String generateCode(Integer id) {
		 // 填充map
	    Map<String, Object> params = new HashMap<String, Object>();
	    params.put("id", id);
	    String code = CodeGenerator.getInstance().generate("PROD_ATTRIBUTE_CODE", params);
	    return code;
	}
	
	
	private List<OpProdSkuAttributeLine> convertLineInfo2DO(List<OpProdSkuAttributeLineInfo> lineInfoList, Integer attributeId, Integer categoryId) {
		if(EmptyUtil.isEmpty(lineInfoList)) {
			throw new OperationException(OperationExceptionErrorCode.ILLEGAL_PARAM, "属性值必须要有一个！");
		}
		if(EmptyUtil.isEmpty(attributeId)) {
			throw new OperationException(OperationExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
		}
		if(EmptyUtil.isEmpty(categoryId)) {
			throw new OperationException(OperationExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
		}
		List<OpProdSkuAttributeLine>  lineList = new ArrayList<OpProdSkuAttributeLine>();
		for(OpProdSkuAttributeLineInfo lineInfo : lineInfoList) {
			OpProdSkuAttributeLine line = new OpProdSkuAttributeLine();
			BeanUtils.copyProperties(lineInfo, line);
			line.setAttributeId(attributeId);
			line.setCategoryId(categoryId);
			if(line.getId() != null) {
				OpProdSkuAttributeLine opProdSkuAttributeLine = opProdSkuAttributeLineMapper.selectByPrimaryKey(line.getId());
				if(opProdSkuAttributeLine != null) {
					Byte lineStatus = opProdSkuAttributeLine.getLineStatus();
					//保存的时候只审核驳回和新增的属性值
					if(lineStatus == OpProdSkuAttributeLineStatusEnum.REJECT.status ) {
						line.setLineStatus(OpProdSkuAttributeLineStatusEnum.REVIEW.status);
					} else {
						line.setLineStatus(null);
					}
				}
			} else {
				line.setLineStatus(OpProdSkuAttributeLineStatusEnum.REVIEW.status);
			}
			lineList.add(line);
		}
		return lineList;
	}
	@Override
	public int approvalProdSkuAttribute(Integer attributeId, boolean isPass) {
		OpProdSkuAttributeInfo attributeInfo = findInfoById(attributeId, false);
		if(isPass) {
			attributeInfo.setAttributeStatus(OpProdSkuAttributeStatusEnum.COMPLETED_REVIEW.status);
		} else {
			attributeInfo.setAttributeStatus(OpProdSkuAttributeStatusEnum.REJECT.status);
		}
		
		OpProdSkuAttribute opProdSkuAttribute = new OpProdSkuAttribute();
		BeanUtils.copyProperties(attributeInfo, opProdSkuAttribute);
		opProdSkuAttributeDomain.updateProdSkuAttribute(opProdSkuAttribute);
		opProdSkuAttributeDomain.approvalProdSkuAttributeVal(attributeId, isPass);
		return 0;
	}

	@Override
	public int associatedAttributes(String skuCode, List<Integer> attributeLineIds) {
		return 0;
	}

	@Override
	public List<OpProdSkuAttributeInfo> findByCond(OpProdSkuAttributeInfoCond cond) {
		return opProdSkuAttributeDomain.findByCond(cond);
	}

	@Override
	public OpProdSkuAttributeInfo findInfoById(Integer id, boolean cascaded) {
		OpProdSkuAttributeInfo attributeInfo = opProdSkuAttributeDomain.findById(id);
		if(attributeInfo != null) {
			if(cascaded) {
				attributeInfo.setLineList(findLineByAttributeId(id));
			}
		}
		return attributeInfo;
	}

	@Override
	public List<OpProdSkuAttributeLineInfo> findLineByAttributeId(Integer attributeId) {
		List<OpProdSkuAttributeLine> lines = opProdSkuAttributeDomain.findLineByAttributeId(attributeId);
		List<OpProdSkuAttributeLineInfo> lineInfoList = new ArrayList<OpProdSkuAttributeLineInfo>();
		if(EmptyUtil.isNotEmpty(lines)) {
			for(OpProdSkuAttributeLine line : lines) {
				OpProdSkuAttributeLineInfo opProdSkuAttributeLineInfo = new OpProdSkuAttributeLineInfo();
				BeanUtils.copyProperties(line, opProdSkuAttributeLineInfo);
				lineInfoList.add(opProdSkuAttributeLineInfo);
			}
		}
		return lineInfoList;
	}

	@Override
	public int batchApprovalProdSkuAttribute(List<Integer> attributeIdList, boolean isPass) {
		if(EmptyUtil.isNotEmpty(attributeIdList)) {
			for(Integer attributeId : attributeIdList) {
				this.approvalProdSkuAttribute(attributeId, isPass);
			}
		}
		return 1;
	}

	@Override
	public List<String> findAttributeNameByCategoryId(Integer categoryId) {
		return opProdSkuAttributeDomain.findAttributeNameByCategoryId(categoryId);
	}

	@Override
	@Transactional
	public int delAttributeById(Integer attributeId) {
		if(EmptyUtil.isNotEmpty(opProdSkuAttributeDomain.findLineByAttributeIdAndStatus(attributeId, OpProdSkuAttributeLineStatusEnum.REVIEW.status.intValue()))) {
			throw new OperationException("属性中存在审批中的属性值，无法删除!");
		}
		releaseRelationByAttributeId(attributeId);
		opProdSkuAttributeLineMapper.deleteByAttributeId(attributeId);
		opProdSkuAttributeDomain.deleAttributeById(attributeId);
		return 1;
	}

	@Override
	public List<OpProdSkuAttributeInfo> findAttributeAndLineByCategoryId(Integer categoryId, Integer lineStatus) {
		return opProdSkuAttributeDomain.findAttributeAndLineByCategoryId(categoryId, lineStatus);
	}

	@Override
	public void setupSkuAttribute(String skuCode, List<Integer> attributeLineList) {
		if(attributeLineList != null) {
			for(Integer lineId : attributeLineList) {
				OpProdSkuAttributeRelation opProdSkuAttributeRelation = new OpProdSkuAttributeRelation();
				opProdSkuAttributeRelation.setAttributeLineId(lineId);
				opProdSkuAttributeRelation.setSkuCode(skuCode);
				opProdSkuAttributeDomain.insertSkuAttributeRelation(opProdSkuAttributeRelation);
			}
		}
	}

	@Override
	@Transactional
	public void batchSetupSkuAttribute(List<OpProdSkuAttributeRelationVO> relationList, List<OpProdSkuAttributeRelationInfo> deleteRelationList) {
		if(relationList != null) {
			for(OpProdSkuAttributeRelationVO lineVO : relationList) {
				OpProdSkuAttributeRelation opProdSkuAttributeRelation = new OpProdSkuAttributeRelation();
				BeanUtils.copyProperties(lineVO, opProdSkuAttributeRelation);
				opProdSkuAttributeDomain.insertSkuAttributeRelation(opProdSkuAttributeRelation);
			}
		}
		batchReleaseSkuAttribute(deleteRelationList);
	}

	@Override
	public List<OpProdSkuAttributeRelationInfo> findAttributeLinesBySkuCode(String skuCode) {
		return opProdSkuAttributeRelationMapper.selectBySkuCode(skuCode);
	}

	@Override
	public List<OpProdSkuAttributeLineInfo>  findAttributeValByCond(OpProdSkuAttributeInfoCond cond) {
		return opProdSkuAttributeMapper.findAttributeValByCond(cond);
	}

	@Override
	@Transactional
	public void batchReleaseSkuAttribute(List<OpProdSkuAttributeRelationInfo> relationList) {
		if(EmptyUtil.isNotEmpty(relationList)) {
			for(OpProdSkuAttributeRelationInfo  opProdSkuAttributeRelationVO : relationList) {
				opProdSkuAttributeRelationMapper.releaseSkuAttributeRelation(opProdSkuAttributeRelationVO.getSkuCode(), opProdSkuAttributeRelationVO.getAttributeLineId());
			}
		}
		
	}

	@Override
	public OpProdSkuAttributeInfo findRepeatAttribute(String attributeName, Integer categoryId) {
/*		OpProdSkuAttributeExample example = new OpProdSkuAttributeExample();
		example.createCriteria().andAttributeNameEqualTo(attributeName);
		example.createCriteria().andCategoryIdEqualTo(categoryId);*/
		List<OpProdSkuAttributeInfo> attributeList =  opProdSkuAttributeMapper.findRepeatAttribute(attributeName, categoryId);
		if(attributeList != null && attributeList.size() > 0) {
			return attributeList.get(0);
		}
		return null;
	}

	@Override
	public List<OpProdSkuAttributeLineInfo> findLineByAttributeIdAndStatus(Integer attributeId, Integer lineStatus) {
		List<OpProdSkuAttributeLine>  lineList = opProdSkuAttributeDomain.findLineByAttributeIdAndStatus(attributeId, lineStatus);
		List<OpProdSkuAttributeLineInfo> lineInfoList = new ArrayList<OpProdSkuAttributeLineInfo>();
		if(EmptyUtil.isNotEmpty(lineList)) {
			for(OpProdSkuAttributeLine line : lineList) {
				OpProdSkuAttributeLineInfo opProdSkuAttributeLineInfo = new OpProdSkuAttributeLineInfo();
				BeanUtils.copyProperties(line, opProdSkuAttributeLineInfo);
				lineInfoList.add(opProdSkuAttributeLineInfo);
			}
		}
		return lineInfoList;
	}

	@Override
	public void releaseRelationByAttributeId(Integer attributeId) {
		List<OpProdSkuAttributeLine>  lineList = opProdSkuAttributeLineMapper.findLineByAttributeId(attributeId);
		if(EmptyUtil.isNotEmpty(lineList)) {
			for(OpProdSkuAttributeLine line : lineList) {
				opProdSkuAttributeRelationMapper.releaseSkuAttributeRelation(null, line.getId());
			}
			
		}
		
	}

}
