/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.domain.OpProdCanSelfDeliveryDomain;
import com.thebeastshop.pegasus.merchandise.model.OpProdCanSelfDelivery;
import com.thebeastshop.pegasus.merchandise.service.McOpProdCanSelfDeliveryService;
import com.thebeastshop.pegasus.merchandise.vo.OpProdCanSelfDeliveryVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: OpProdCanDeliveryServiceImpl.java, v 0.1 2015-08-14 17:06
 */
@Service("mcOpProdCanSelfDeliveryService")
public class McOpProdCanSelfDeliveryServiceImpl implements McOpProdCanSelfDeliveryService {

    @Autowired
    private OpProdCanSelfDeliveryDomain opProdCanSelfDeliveryDomain;

    @Override
    public Long create(OpProdCanSelfDeliveryVO vo) {
        OpProdCanSelfDelivery delivery = opProdCanSelfDeliveryDomain.buildFromVO(vo);
        opProdCanSelfDeliveryDomain.create(delivery);
        return delivery.getId();
    }

    @Override
    public boolean update(OpProdCanSelfDeliveryVO vo) {
        OpProdCanSelfDelivery delivery = opProdCanSelfDeliveryDomain.buildFromVO(vo);
        return opProdCanSelfDeliveryDomain.update(delivery);
    }

    @Override
    public boolean deleteById(Long id) {
        return opProdCanSelfDeliveryDomain.deleteById(id);
    }

    @Override
    public List<OpProdCanSelfDeliveryVO> findByProdId(Long prodId) {
        List<OpProdCanSelfDelivery> list =opProdCanSelfDeliveryDomain.findByProdId(prodId);
        return  BeanUtil.buildListFrom(list, OpProdCanSelfDeliveryVO.class);
    }

    @Override
    public boolean deleteByProdId(Long prodId) {
        return false;
    }
}
