/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;


import com.thebeastshop.pegasus.merchandise.domain.OpProdAssembleDomain;
import com.thebeastshop.pegasus.merchandise.service.McOpProdAssembleService;
import com.thebeastshop.pegasus.merchandise.vo.OpProdAssembleVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/12/29 14:11
 */
@Service("mcOpProdAssembleService")
public class McOpProdAssembleServiceImpl implements McOpProdAssembleService {

    @Autowired
    private OpProdAssembleDomain opProdAssembleDomain;

    @Override
    public Long create(OpProdAssembleVO record) {
        return opProdAssembleDomain.create(opProdAssembleDomain.buildFromVO(record));
    }

    @Override
    public boolean update(OpProdAssembleVO record) {
        return opProdAssembleDomain.update(opProdAssembleDomain.buildFromVO(record));
    }

    @Override
    public List<OpProdAssembleVO> findByProId(Long prodId) {
        return opProdAssembleDomain.findByProdId(prodId);
    }


}