package com.thebeastshop.pegasus.merchandise.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import pers.richard.ormybatis.util.ObjUtils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.thebeastshop.member.point.constant.MemberPointConstant;
import com.thebeastshop.member.point.cron.MemberCommonPointCron;
import com.thebeastshop.member.point.exception.ArgumentException;
import com.thebeastshop.member.point.service.MemberPointService;
import com.thebeastshop.member.point.vo.MemberResponseVO;
import com.thebeastshop.pegasus.component.coupon.client.CouponClient;
import com.thebeastshop.pegasus.component.coupon.vo.SendCouponUserVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.merchandise.IService.ILotteryActivityService;
import com.thebeastshop.pegasus.merchandise.util.DateUtils;
import com.thebeastshop.scm.dao.InterestGoodsSkuDao;
import com.thebeastshop.scm.dao.LotteryActivityAwardDao;
import com.thebeastshop.scm.dao.LotteryActivityAwardTypeDao;
import com.thebeastshop.scm.dao.LotteryActivityDao;
import com.thebeastshop.scm.dao.LotteryActivityManageLogDao;
import com.thebeastshop.scm.dao.LotteryActivityPrizeDao;
import com.thebeastshop.scm.dao.LotteryActivityPrizeRecordDao;
import com.thebeastshop.scm.dao.MemberDao;
import com.thebeastshop.scm.po.LotteryActivity;
import com.thebeastshop.scm.po.LotteryActivityAward;
import com.thebeastshop.scm.po.LotteryActivityManageLog;
import com.thebeastshop.scm.po.LotteryActivityPrize;
import com.thebeastshop.scm.po.LotteryActivityPrizeRecord;
import com.thebeastshop.scm.po.Member;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;
import com.thebeastshop.scm.vo.lottery.DrawResultException;
import com.thebeastshop.scm.vo.lottery.LotteryActivityAwardEditVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityDrawParamVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityDrawResultVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityEditVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityRecordVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivitySaveVO;

@Service
public class LotteryActivityService implements ILotteryActivityService {
	protected static final Logger log = LoggerFactory.getLogger(LotteryActivityService.class);
	
	@Resource private MemberDao memberDao;
	@Resource private LotteryActivityDao lotteryActivityDao;
	@Resource private LotteryActivityAwardDao lotteryActivityAwardDao;
	@Resource private LotteryActivityAwardTypeDao lotteryActivityAwardTypeDao;
	@Resource private LotteryActivityPrizeDao lotteryActivityPrizeDao;
	@Resource private LotteryActivityPrizeRecordDao lotteryActivityPrizeRecordDao;
	@Resource private LotteryActivityManageLogDao lotteryActivityManageLogDao;
	@Resource private InterestGoodsSkuDao interestGoodsSkuDao;
	
	@Resource private MemberPointService memberPointService;
	@Resource private InterestGoodsService interestGoodsService;
	
	private static Hashtable<String, Boolean> hashtable = new Hashtable<>();
	
	@Autowired
	private CouponClient couponClient;


	@Override
	public List<LotteryActivity> findAll() {
		log.info("查所有的抽奖活动列表");
		return lotteryActivityDao.findAll();
	}
	
	@Override
	public List<Map> winListByAwardId(Integer awardId){
		List<Map> list = this.lotteryActivityPrizeRecordDao.winListByAwardId(awardId);
		for (Map map : list) {
			int title = MapUtils.getIntValue(map, "title"); 
			String titleName = "";
			if (title == 1) {
				titleName = "先生";
			} else if (title == 2) {
				titleName = "女士";
			} else if (title == 3) {
				titleName = "小姐";
			} else if (title == 4 && title == 0) {
				titleName = "保密";
			}
			map.put("titleName", titleName);
		}
		return list;
	}
	
	@Override
	public void save(LotteryActivitySaveVO vo) {
		LotteryActivity lotteryActivity = vo.toLotteryActivity();
		log.info("保存抽奖活动 LotteryActivitySaveVO:{}", vo);
		lotteryActivityDao.insertOrUpdate(lotteryActivity);
		List<LotteryActivityAward> lotteryActivityAwardList = vo.toLotteryActivityAwardList(lotteryActivity.getId());
		lotteryActivityAwardDao.batchSave(lotteryActivityAwardList);
		for (int i = 0; i < lotteryActivityAwardList.size(); i++) {
			LotteryActivityAward lotteryActivityAward = lotteryActivityAwardList.get(i);
			log.info("保存抽奖活动的奖项表:{}", lotteryActivityAward);
			Integer lotteryActivityAwardId = lotteryActivityAward.getId();
			LotteryActivityPrize lotteryActivityPrize = vo.toLotteryActivityPrize(lotteryActivityAwardId, i);
			lotteryActivityPrizeDao.deleteByAwardId(lotteryActivityAwardId);
			lotteryActivityPrizeDao.insertOrUpdate(lotteryActivityPrize);
			/*List<LotteryActivityAwardType> lotteryActivityAwardTypeList = vo.toLotteryActivityAwardType(lotteryActivityAwardId, i);
			lotteryActivityAwardTypeDao.save(lotteryActivityAwardTypeList);*/
		}
		this.saveLog(lotteryActivity, lotteryActivityAwardList, vo);
	}
	
	@Override
	public LotteryActivityEditVO byLotteryActivityId(Integer lotteryActivityId){
		LotteryActivity lotteryActivity = lotteryActivityDao.selectOne(lotteryActivityId);
		List<LotteryActivityAwardEditVO> lotteryActivityAwardEditVOList = lotteryActivityAwardDao.getLotteryActivityAwardEditVOByLotteryActivityId(lotteryActivityId);
		for (LotteryActivityAwardEditVO lotteryActivityAwardEditVO : lotteryActivityAwardEditVOList) {
			//如果是商品权益,则去权益表取sku总数量
			if (LotteryActivityPrize.Type.PRODUCT.toString().equals(lotteryActivityAwardEditVO.getPrizeType())) {
				int InterestId = NumberUtils.toInt(lotteryActivityAwardEditVO.getPrizeTypeNum());
				int totalSkuQuantity = interestGoodsSkuDao.sumQuantityByInterestId(InterestId);
				lotteryActivityAwardEditVO.setAwardQuantity(totalSkuQuantity);
			}
		}
		/*for (LotteryActivityAwardEditVO lotteryActivityAwardEditVO : lotteryActivityAwardEditVOList) {
			List<String> typeList = lotteryActivityAwardTypeDao.getTypeByAwardId(lotteryActivityAwardEditVO.getAwardId());
			lotteryActivityAwardEditVO.setAwardType(StringUtils.join(typeList,"_"));
		}*/
		return new LotteryActivityEditVO(lotteryActivity, lotteryActivityAwardEditVOList);
	}
	
	@Override
	public List<LotteryActivityRecordVO> winList(Integer memberId, Integer lotteryActivityId){
		return lotteryActivityPrizeRecordDao.getWinByMemberIdAndLotteryActivityId(memberId, lotteryActivityId);
	}
	
	@Override
	public LotteryActivityRecordVO byLotteryActivityPrizeRecordId(Integer lotteryActivityPrizeRecordId) {
		return lotteryActivityPrizeRecordDao.getLotteryActivityRecordVOById(lotteryActivityPrizeRecordId);
	}
	
	@Override
	public List<LotteryActivityRecordVO> queryLastWinRecord(Integer limit) {
		List<LotteryActivityRecordVO> recordList = lotteryActivityPrizeRecordDao.lastNewest(limit);
		return recordList;
	}
	
	@Override
	public LotteryActivityDrawResultVO drawLottery(LotteryActivityDrawParamVO paramVO){
		log.info("抽奖参数:{}", paramVO);
		Integer memberId = paramVO.getMemberId();
		Integer lotteryActivityId = paramVO.getLotteryActivityId();
		String sysId = paramVO.getSysId();
		try{
			if (paramVO.getIsCheck()) {
				DrawResultException drawResultException = this.checkDrawLottery(memberId, lotteryActivityId, sysId);
				if (drawResultException != null) {
					return LotteryActivityDrawResultVO.newInstanceFail(drawResultException);
				}
			}
			//扣除会员积分
			LotteryActivity lotteryActivity = lotteryActivityDao.selectOne(lotteryActivityId);
			Member member = memberDao.selectOne(memberId);
			if (lotteryActivity.getConsumePoint() > 0) {
				MemberCommonPointCron subtractionMemberCommonPointCron = new MemberCommonPointCron();
				subtractionMemberCommonPointCron.setMemberCode(member.getCode());
				subtractionMemberCommonPointCron.setMemberId(member.getId().longValue());
				subtractionMemberCommonPointCron.setMemberPointType(MemberPointConstant.Pont_Type_Id.TYPE_LUCK_ACTIVITY_SUB);
				subtractionMemberCommonPointCron.setPoint(new BigDecimal(lotteryActivity.getConsumePoint()));
				MemberResponseVO responseVO = memberPointService.subtractionMemberCommonPoint(subtractionMemberCommonPointCron);
				if (responseVO.getMeta().getErrno() != 0) {//扣积分失败
					return LotteryActivityDrawResultVO.newInstanceFail(DrawResultException.POINT_INTERFACE_ERROR);
				}
			}
			
			//去抽奖
			List<LotteryActivityAward> lotteryActivityAwardList = this.createLotteryList(lotteryActivityId);
			int random = RandomUtils.nextInt(0, 100);
			LotteryActivityAward lotteryActivityAward = ObjUtils.get(lotteryActivityAwardList, random);
			
			//中奖修改库存
			if (lotteryActivityAward != null) {
				boolean isSuccess = lotteryActivityAwardDao.updateStock(lotteryActivityAward.getId());
				if (isSuccess == false) {//并发更新失败,设置为奖项为null表示没有中奖
					lotteryActivityAward = null;
				}
			}
			//中奖则发奖品
			InterestGoodsGetVO interestGoodsGetVO = null;
			if (lotteryActivityAward != null) {
				LotteryActivityPrize lotteryActivityPrize = lotteryActivityPrizeDao.byAwardId(lotteryActivityAward.getId());
				String type = lotteryActivityPrize.getType();
				String typeNum = lotteryActivityPrize.getTypeNum();
				if (LotteryActivityPrize.Type.COUPON.toString().equals(type)) {//发送奖品券
					SendCouponUserVO sendCouponUserVO = new SendCouponUserVO();
					sendCouponUserVO.setCouponSampleId(NumberUtils.toLong( typeNum));
					sendCouponUserVO.setMemberIds(Arrays.asList(memberId.longValue()));
					ApiResult apiResult = couponClient.sendCouponUsers(sendCouponUserVO);
					if (apiResult.getData() == null) {//发奖品券失败,设置中奖失败
						lotteryActivityAward = null;
					}
				} else if (LotteryActivityPrize.Type.POINT.toString().equals(type)) {//发送积分
					MemberCommonPointCron memberCommonPointCron = new MemberCommonPointCron();
					memberCommonPointCron.setMemberCode(member.getCode());
					memberCommonPointCron.setMemberId(member.getId().longValue());
					memberCommonPointCron.setMemberPointType(MemberPointConstant.Pont_Type_Id.TYPE_LUCK_ACTIVITY_ADD);
					memberCommonPointCron.setPoint(new BigDecimal(typeNum));
					boolean bool = memberPointService.addMemberCommonPoint(memberCommonPointCron);
					if (!bool) {//加积分失败,设置中奖失败
						lotteryActivityAward = null;
					}
				} else if (LotteryActivityPrize.Type.PRODUCT.toString().equals(type)){//权益发送
					Integer interestId = NumberUtils.toInt(lotteryActivityPrize.getTypeNum());
					interestGoodsGetVO = interestGoodsService.getInterestGoods(memberId, interestId);
				} else if (LotteryActivityPrize.Type.COUPON_THIRD.toString().equals(type)){//第三券发送
					Long cstpId = NumberUtils.toLong(typeNum);
					ApiResult<Boolean> result = couponClient.exchangeToMember(cstpId, memberId.longValue());
					if (result.getData() == null && result.getData() == false) {//第三方券发送失败,设置中奖失败
						lotteryActivityAward = null;
					}
				}
			}
			//保存抽奖记录
			LotteryActivityPrizeRecord lotteryActivityPrizeRecord = lotteryActivityPrizeRecordDao.save(memberId, lotteryActivityId, lotteryActivityAward, sysId);
			LotteryActivityRecordVO recordVO = lotteryActivityPrizeRecordDao.getLotteryActivityRecordVOById(lotteryActivityPrizeRecord.getId());
			if (recordVO == null) {
				return LotteryActivityDrawResultVO.newInstanceSuccess(null);
			} else {
				recordVO.setInterestGoodsGetVO(interestGoodsGetVO);
				return LotteryActivityDrawResultVO.newInstanceSuccess(recordVO);
			}
		}
		catch(ArgumentException e){
			log.info(null, e);
			return LotteryActivityDrawResultVO.newInstanceFail(DrawResultException.POINT_INTERFACE_ERROR);
		}
		catch(Exception e){
			log.error(null, e);
			return LotteryActivityDrawResultVO.newInstanceFail(DrawResultException.ERROR);
		}
	}

	/**
	 * 校验抽奖规则
	 * @param memberId
	 * @param lotteryActivityId
	 * @return
	 */
	@Override
	public DrawResultException checkDrawLottery(Integer memberId, Integer lotteryActivityId, String sysId){
		//同一用户2秒内不能重复请求
		log.info("请求memberid:{} sysId:{}", memberId , sysId);
		String key = memberId + "_" + System.currentTimeMillis() / 2000;
		synchronized (LotteryActivityService.class) {
			if (hashtable.get(key) != null) {
				return DrawResultException.FREQUENCY_REQUEST;
			} else {
				hashtable.put(key, true);
			}
		}
		if (hashtable.size() > 1000) {//防止内存溢出
			hashtable.clear();
		}
		Member member = memberDao.selectOne(memberId);
		if (member == null) {
			return DrawResultException.MEMBER_NOT_FOUND;
		}
		LotteryActivity lotteryActivity = lotteryActivityDao.selectOne(lotteryActivityId);
		if (lotteryActivity == null) {
			return DrawResultException.ACTIVITY_ERROR;
		}
		if (lotteryActivity.getStartTime().after(DateUtils.getCurrentDateYMD())) {
			return DrawResultException.ACTIVITY_ERROR;
		}
		if (lotteryActivity.getEndTime().before(DateUtils.getCurrentDateYMD())) {
			return DrawResultException.ACTIVITY_ERROR;
		}
		//活动配制的限制抽奖判断
		String limitType = StringUtils.trim(lotteryActivity.getLimitType());
		Integer limitNum = lotteryActivity.getLimitNum();
		if (LotteryActivity.LimitType.DAY.toString().equals(limitType)) {
			Integer dayCount = lotteryActivityPrizeRecordDao.getDayCountByMemberIdAndLotteryActivityId(memberId, lotteryActivityId);
			if (dayCount >= limitNum) {
				return DrawResultException.NO_CHANCE;
			}
		} else if (StringUtils.equalsIgnoreCase(LotteryActivity.LimitType.SYS_ID.toString(), limitType)) {
			Integer sysIdCount = lotteryActivityPrizeRecordDao.bySysId(memberId, lotteryActivityId, sysId);
			if (sysIdCount >= limitNum) {
				return DrawResultException.NO_CHANCE;
			}
		}
		//检验积分是否够用
		if (lotteryActivity.getConsumePoint() > 0) {
			BigDecimal memberPoint = memberPointService.findCommonValidMemberLevelByparam(memberId.longValue(), member.getCode());
			if (new BigDecimal(lotteryActivity.getConsumePoint()).compareTo(memberPoint) == 1) {
				return DrawResultException.POINT_NOT_ENOUGH;
			}
		}
		return null;
	}
	
	
	/**
	 * 产生有100个的位置的奖项的List,每个位置放一个奖品或者null,用来抽奖
	 */
	private List<LotteryActivityAward> createLotteryList(Integer lotteryActivityId){
		//按一个奖项的中奖概率增加奖品到集合中
		List<LotteryActivityAward> result = new ArrayList<>();
		List<LotteryActivityAward> awardList = lotteryActivityAwardDao.byLotteryActivityIdAndStock(lotteryActivityId);
		//awardList = lotteryActivityAwardDao.byLotteryActivityIdAndAwardType(lotteryActivityId, LotteryActivityAwardType.Type.HAITAO);
		for (LotteryActivityAward lotteryActivityAward : awardList) {
			for (int i = 0; i < lotteryActivityAward.getOdds(); i++) {
				result.add(lotteryActivityAward);
			}
		}
		//不够100补null
		if (result.size() < 100) {
			int size = 100 - result.size();
			for (int i = 0; i < size; i++) {
				result.add(null);
			}
		}
		return result;
	}
	
	/**
	 * 保存日志
	 */
	private void saveLog(LotteryActivity lotteryActivity, List<LotteryActivityAward> lotteryActivityAwardList, LotteryActivitySaveVO vo) {
		Map lotteryActivityMap = lotteryActivity.toMap();
		lotteryActivityMap.remove("updateTime");
		List<Map> lotteryActivityAwardMapList = new ArrayList<Map>();
		for (LotteryActivityAward lotteryActivityAward : lotteryActivityAwardList) {
			Map lotteryActivityAwardMap = lotteryActivityAward.toMap();
			lotteryActivityAwardMap.remove("lotteryActivityId");
			lotteryActivityAwardMap.remove("winQuantity");
			lotteryActivityAwardMap.remove("version");
			lotteryActivityAwardMap.put("prizeList", lotteryActivityPrizeDao.byAwardId(lotteryActivityAward.getId()).toMap());
			lotteryActivityAwardMapList.add(lotteryActivityAwardMap);
		}
		lotteryActivityMap.put("award", lotteryActivityAwardMapList);
		LotteryActivityManageLog lotteryActivityManageLog = new LotteryActivityManageLog();
		lotteryActivityManageLog.setCreateTime(new Date());
		lotteryActivityManageLog.setCreateUserId(vo.getOperatorId());
		lotteryActivityManageLog.setCreateUserName(vo.getOperatorName());
		lotteryActivityManageLog.setLotteryActivityId(lotteryActivity.getId());
		lotteryActivityManageLog.setUpdateContent(JSONObject.toJSONString(lotteryActivityMap, SerializerFeature.WriteDateUseDateFormat));
		lotteryActivityManageLogDao.insert(lotteryActivityManageLog);
	}
}
