package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import pers.richard.ormybatis.dao.IDao;
import pers.richard.ormybatis.service.BaseService;

import com.thebeastshop.pegasus.merchandise.IService.IChannelService;
import com.thebeastshop.scm.dao.ChannelDao;
import com.thebeastshop.scm.po.Channel;

@Service
public class ChannelService extends BaseService<Channel> implements IChannelService {

	private ChannelDao channelDao;
	
	@Autowired
	public ChannelService(@Qualifier("channelDao") IDao dao) {
		super(dao);
		channelDao = (ChannelDao)super.dao;
	}
	
	public Channel byCode(String code){
		return channelDao.byCode(code);
	}
	
	public List<Channel> findAll(){
		return channelDao.findAll();
	}
}
