package com.thebeastshop.pegasus.merchandise.price;

import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;

/**
 * 原价
 * @author gongjun
 * @since 2016-12-29
 */
public class SourcePrice implements PriceCalculator {

    private BigDecimal price;

    public SourcePrice(BigDecimal price) {
        this.price = price;
    }

    @Override
    public PriceCalculator getPrevPriceCalculator() {
        return this;
    }

    @Override
    public BigDecimal getPrevPrice(List<PriceCalResultVO> results) {
        return price;
    }

    @Override
    public boolean getHasRush() {
        return false;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        return price;
    }
}
