package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsTagCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsTagMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsClPsDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsTagDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuTag;
import com.thebeastshop.pegasus.merchandise.model.ProdTag;
import com.thebeastshop.pegasus.merchandise.vo.PcsTagVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsTagDomain")
public class PcsTagDomainImpl implements PcsTagDomain {

    private static final Logger log = LoggerFactory.getLogger(PcsTagDomainImpl.class);
    @Autowired
    private PcsTagMapper pcsTagMapper;

    @Autowired
    private PcsClPsDomain pcsClPsDomain;

    @Override
    @Transactional
    public int addTag(PcsTagVO tagVO) {
        int ret = pcsTagMapper.insert(tagVO);
        if (ret > 0) {
            Random random = new Random();
            int n = random.nextInt(99);
            tagVO.setCode("T0" + n + tagVO.getId());
            pcsTagMapper.update(tagVO);
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateTag(PcsTagVO tagVO) {
        int ret = pcsTagMapper.update(tagVO);
        List<String> codeList = pcsTagMapper.querySkuCodeListByTagId(tagVO.getId());
        pcsClPsDomain.saveSkuCodeList(codeList, 1);
        return ret;
    }

    @Override
    public PcsTagVO findTagById(Long id) {
        return pcsTagMapper.findById(id);
    }
    
    @Override
	public List<PcsTagVO> queryTagListByProdId(Long prodId) {
    	return pcsTagMapper.queryTagListByProdId(prodId);
	}

    @Override
    public List<ProdSkuVO> queryProdTagListByTagCode(PcsTagCond cond) {
        return pcsTagMapper.queryProdTagListByTagCode(cond);
    }

    @Override
    @Transactional
    public int saveOrUpdateProdTag(ProdTag prodTag) {
        int count = pcsTagMapper.countOfProdTag(prodTag);
        if (count == 0) {
            count = pcsTagMapper.insertProdTag(prodTag);
            log.info("新增"+count);
            log.info("add record:"+prodTag.toString());
            return 1;
        }
        prodTag.setActive(1);
        count = pcsTagMapper.updateProdTag(prodTag);
        log.info("更新："+count);
        log.info("update record:"+prodTag.toString());
        return 2;
    }

    @Override
    @Transactional
    public int updateProdTagByCodeList(ProdSkuVO prod, List<String> codeList, boolean isEmptyBeforeUpdate) {
        Map<String, Object> params = new HashMap<>();
        // 删除无用的关联
        if (isEmptyBeforeUpdate) {
            params.put("productId", prod.getProdId());
            List<ProdTag> toDelProdTagList = pcsTagMapper.queryToDeleteProdTagList(params);
            if (!toDelProdTagList.isEmpty()) {
                List<Long> toDelIdList = new ArrayList<>();
                for (int i = 0; i < toDelProdTagList.size(); i++) {
                    ProdTag toDelProdTag = toDelProdTagList.get(i);
                    toDelIdList.add(toDelProdTag.getId());
                }
                Map<String, Object> delParams = new HashMap<>();
                delParams.put("ids", toDelIdList);
                delParams.put("active", 0);
                //pcsTagMapper.deleteProdTagByIds(delParams);
                int count = pcsTagMapper.updateProdTagActiveByIds(delParams);
                log.info("删除量："+count);
            }
        }

        List<ProdTag> prodTagList = new ArrayList<>();
        for (int i = 0; i < codeList.size(); i++) {
            String code = codeList.get(i);
            ProdTag prodTag = new ProdTag();
            prodTag.setProductCode(prod.getProdCode());
            prodTag.setProductId(prod.getProdId());
            prodTag.setTagCode(code);
            prodTagList.add(prodTag);
        }
        // 添加或更新关联
        int ret = 0;
        for (int i = 0; i < prodTagList.size(); i++) {
            ProdTag prodTag = prodTagList.get(i);
            prodTag.setSort(i);
            ret += saveOrUpdateProdTag(prodTag);
        }
        return ret;
    }

    @Override
    public List<PcsTagVO> queryTagList(Map<String, Object> params) {
        return pcsTagMapper.queryTagList(params);
    }

    @Override
    public List<ProdSkuVO> queryProdSkuListByTagParams(List<String> idList) {
        Map<String, Object> params = new HashMap<>();
        params.put("ids", idList);
        return pcsTagMapper.queryProdSkuListByTagParams(params);
    }

    @Override
    public int saveOrUpdateSkuTag(PcsSkuTag skuTag) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public int deleteProdTagByIds(List<String> idList) {
        Map<String, Object> delParams = new HashMap<>();
        delParams.put("ids", idList);
        delParams.put("active", 0);
        // return pcsTagMapper.deleteProdTagByIds(delParams);
        // 逻辑删除
        return pcsTagMapper.updateProdTagActiveByIds(delParams);
    }

}
