package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsQualityCheckItemMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsQualityCheckItemDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsQualityCheckItem;
import com.thebeastshop.pegasus.merchandise.vo.PcsQualityCheckItemVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by Administrator on 2017/2/13.
 */
@Component("pcsQualityCheckItemDomain")
public class PcsQualityCheckItemDomainImpl extends AbstractBaseDomain<PcsQualityCheckItemVO,PcsQualityCheckItem> implements PcsQualityCheckItemDomain {

    @Autowired
    private PcsQualityCheckItemMapper pcsQualityCheckItemMapper;

    @Override
    public PcsQualityCheckItemVO findById(Long id) {
        return pcsQualityCheckItemMapper.findById(id);
    }

    @Override
    public List<PcsQualityCheckItemVO> findByIds(List<Long> ids) {
        return pcsQualityCheckItemMapper.findByIds(ids);
    }

    @Override
    public List<PcsQualityCheckItemVO> findAll() {
        return pcsQualityCheckItemMapper.findAll();
    }

    @Override
    @Transactional
    public boolean add(PcsQualityCheckItemVO vo) {
        PcsQualityCheckItem record = buildFromVO(vo);
        pcsQualityCheckItemMapper.insert(record);
        vo.setId(record.getId());
        updateCode(generateCode(vo.getId()),vo.getId());
        return true;
    }

    @Override
    @Transactional
    public boolean update(PcsQualityCheckItemVO vo) {
        pcsQualityCheckItemMapper.updateByPrimaryKeySelective(buildFromVO(vo));
        return true;
    }

    @Override
    @Transactional
    public PcsQualityCheckItemVO save(PcsQualityCheckItemVO vo) {
        if(NullUtil.isNotNull(vo.getId())){
            update(vo);
        }else{
            add(vo);
        }
        return vo;
    }

    private void updateCode(String code,Long id){
        PcsQualityCheckItem record = new PcsQualityCheckItem();
        record.setId(id);
        record.setCode(code);
        pcsQualityCheckItemMapper.updateByPrimaryKeySelective(record);
    }

    private String generateCode(Long id){
        String code = id.toString();
        if(code.length()>=3){
            return code;
        }
        StringBuilder sb = new StringBuilder();
        for(int i=code.length();i<3;i++){
            sb.append("0");
        }
        return sb.toString()+code;
    }
}
