package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsReceiveRuleCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsMaterialCategoryMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsReceiveRuleMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsMaterialCategoryDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsMaterialCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsMaterialCategoryExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsMaterialCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsReceiveRuleVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2017/2/9.
 */
@Component("pcsMaterialCategoryDomain")
public class PcsMaterialCategoryDomainImpl extends AbstractBaseDomain<PcsMaterialCategoryVO, PcsMaterialCategory> implements PcsMaterialCategoryDomain {

    @Autowired
    private PcsMaterialCategoryMapper pcsMaterialCategoryMapper;

    @Autowired
    private PcsReceiveRuleMapper pcsReceiveRuleMapper;

    @Override
    @Transactional
    public boolean add(PcsMaterialCategoryVO vo) {
        if(NullUtil.isNotNull(vo.getParentId())){
            PcsMaterialCategoryVO parent = findById(vo.getParentId());
            if(NullUtil.isNull(parent)){
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "父类目不存在！");
            }
            //检查父节点是否是叶子节点
            if(NullUtil.isNull(vo.isFocus()) || !vo.isFocus()){
                List<PcsMaterialCategoryVO> children = findByParentId(vo.getParentId());
                if(EmptyUtil.isEmpty(children)){
                    PcsReceiveRuleCond ruleCond = new PcsReceiveRuleCond();
                    List<Long> categoryIds = new ArrayList<>();
                    categoryIds.add(vo.getParentId());
                    ruleCond.setMaterialCategoryIds(categoryIds);
                    List<PcsReceiveRuleVO> ruleList = pcsReceiveRuleMapper.findByCond(ruleCond);
                    if(EmptyUtil.isNotEmpty(ruleList)){
                        throw new PurchaseException(PurchaseExceptionErrorCode.WARN_SECOND_CHECK, "该节点收货规则讲转移至新增的子类！");
                    }
                }
            }
        }
        PcsMaterialCategory record = buildFromVO(vo);
        pcsMaterialCategoryMapper.insert(record);
        vo.setId(record.getId());
        pcsReceiveRuleMapper.changeMaterialCategoryQcItemId(record.getId(),record.getParentId());
        pcsReceiveRuleMapper.changeReceiveRuleQcItemId(record.getId(),record.getParentId());
        return true;
    }

    @Override
    @Transactional
    public boolean update(PcsMaterialCategoryVO vo) {
        PcsMaterialCategoryVO tmp = findById(vo.getId());
        if(NullUtil.isNull(tmp)){
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "类目不存在！");
        }
        pcsMaterialCategoryMapper.updateByPrimaryKeySelective(buildFromVO(vo));
        return true;
    }

    @Override
    @Transactional
    public PcsMaterialCategoryVO save(PcsMaterialCategoryVO vo) {
        if(NullUtil.isNull(vo.getId())){
            add(vo);
        }else{
            update(vo);
        }
        return vo;
    }


    @Override
    @Transactional
    public boolean del(Long id) {
        List<PcsMaterialCategoryVO> subItems = this.findByParentId(id);
        if(EmptyUtil.isNotEmpty(subItems)){
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "存在子类的材质无法删除！");
        }
        pcsMaterialCategoryMapper.deleteByPrimaryKey(id);
        return true;
    }

    @Override
    public List<PcsMaterialCategoryVO> findAll() {
        List<PcsMaterialCategoryVO> list = pcsMaterialCategoryMapper.findAll();
        return list;
    }

    @Override
    public PcsMaterialCategoryVO findById(Long id) {
        return pcsMaterialCategoryMapper.findById(id);
    }

    @Override
    public List<PcsMaterialCategoryVO> findByParentId(Long parentId) {
        return pcsMaterialCategoryMapper.findByParentId(parentId);
    }

    @Override
    public List<PcsMaterialCategoryVO> findLeafById(List<Long> ids) {
        return pcsMaterialCategoryMapper.findLeafById(ids);
    }
}
