package com.thebeastshop.pegasus.merchandise.domain.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.merchandise.cond.OpProdSkuAttributeInfoCond;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeLineMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeRelationMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuAttributeDomain;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.exception.OperationExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttribute;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeLine;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeLineExample;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeRelation;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeInfo;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

@Component("opProdSkuAttributeDomain")
public class OpProdSkuAttributeDomainImpl implements OpProdSkuAttributeDomain {
	
	@Autowired
	private OpProdSkuAttributeMapper opProdSkuAttributeMapper;
	@Autowired
	private OpProdSkuAttributeLineMapper opProdSkuAttributeLineMapper;
	@Autowired
	private OpProdSkuAttributeRelationMapper opProdSkuAttributeRelationMapper;

	@Override
	public OpProdSkuAttributeInfo buildFromModel(OpProdSkuAttribute record) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<OpProdSkuAttributeInfo> buildFromModelList(List<OpProdSkuAttribute> record) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public OpProdSkuAttribute buildFromVO(OpProdSkuAttributeInfo vo) {
		return null;
	}

	@Override
	public List<OpProdSkuAttribute> buildFromVOList(List<OpProdSkuAttributeInfo> vo) {
		return null;
	}

	@Override
	public int saveOpProdSkuAttribute(OpProdSkuAttribute opProdSkuAttribute) {
		if(EmptyUtil.isNotEmpty(opProdSkuAttribute.getId())) {
			return opProdSkuAttributeMapper.updateByPrimaryKeySelective(opProdSkuAttribute);
		}
		return opProdSkuAttributeMapper.insertSelective(opProdSkuAttribute);
	}

	@Override
	public int saveOpProdSkuAttributeLine(List<OpProdSkuAttributeLine> lineList) {
		if(lineList != null) {
			for(OpProdSkuAttributeLine line : lineList) {
				if(line.getId()  == null) {
					opProdSkuAttributeLineMapper.insertSelective(line);
				} else {
					opProdSkuAttributeLineMapper.updateByPrimaryKeySelective(line);
				}
				
			}
		} else {
			throw new OperationException(OperationExceptionErrorCode.ILLEGAL_PARAM);
		}
		return 0;
	}

	@Override
	public int saveOpProdSkuAttributeRelation(List<OpProdSkuAttributeRelation> relationList) {
		if(relationList != null) {
			for(OpProdSkuAttributeRelation relation : relationList) {
				opProdSkuAttributeRelationMapper.insertSelective(relation);
			}
		} else {
			throw new OperationException(OperationExceptionErrorCode.ILLEGAL_PARAM);
		}
		return 0;
	}

	@Override
	public List<OpProdSkuAttributeInfo> findByCond(OpProdSkuAttributeInfoCond cond) {
		return opProdSkuAttributeMapper.findByCond(cond);
	}

	@Override
	public OpProdSkuAttributeInfo findById(Integer id) {
		return opProdSkuAttributeMapper.findById(id);
	}

	@Override
	public List<OpProdSkuAttributeLine> findLineByAttributeId(Integer attributeId) {
		return opProdSkuAttributeLineMapper.findLineByAttributeId(attributeId);
	}

	@Override
	@Transactional
	public void deleteByLineIds(List<Integer> lineIds) {
		if(EmptyUtil.isNotEmpty(lineIds)) {
			for(Integer lineId: lineIds) {
				opProdSkuAttributeLineMapper.deleteByPrimaryKey(lineId);
				opProdSkuAttributeRelationMapper.releaseSkuAttributeRelation(null, lineId);
			}
		}
		
	}

	@Override
	public void approvalProdSkuAttributeVal(Integer attributeId, boolean isPass) {
		opProdSkuAttributeLineMapper.approvalProdSkuAttributeVal(attributeId, isPass);
		
	}

	@Override
	public int updateProdSkuAttribute(OpProdSkuAttribute opProdSkuAttribute) {
		return opProdSkuAttributeMapper.updateByPrimaryKeySelective(opProdSkuAttribute);
	}

	@Override
	public List<String> findAttributeNameByCategoryId(Integer categoryId) {
		return opProdSkuAttributeMapper.findAttributeNameByCategoryId(categoryId);
	}

	@Override
	public int deleAttributeById(Integer attributeId) {
		return opProdSkuAttributeMapper.deleteByPrimaryKey(attributeId);
	}

	@Override
	public int deleLineByAttributeId(Integer attributeId) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public List<OpProdSkuAttributeInfo> findAttributeAndLineByCategoryId(Integer categoryId, Integer lineStatus) {
		return opProdSkuAttributeMapper.findAttributeAndLineByCategoryId(categoryId, lineStatus);
	}

	@Override
	public int insertSkuAttributeRelation(OpProdSkuAttributeRelation relation) {
		return opProdSkuAttributeRelationMapper.insertSelective(relation);
	}

	@Override
	public List<OpProdSkuAttributeLine> findLineByAttributeIdAndStatus(Integer attributeId, Integer lineStatus) {
		/*OpProdSkuAttributeLineExample example = new OpProdSkuAttributeLineExample();
		example.createCriteria().andAttributeIdEqualTo(attributeId);
		example.createCriteria().andLineStatusEqualTo(lineStatus);*/
		return opProdSkuAttributeLineMapper.findLineByAttributeIdAndStatus(attributeId, lineStatus.byteValue());
	}

}
