package com.thebeastshop.pegasus.merchandise.domain;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.thebeastshop.pegasus.merchandise.cond.OpProdSkuAttributeInfoCond;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttribute;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeLine;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeRelation;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeInfo;

/**
 * 
 * @author Gary 
 * @version <b>1.0.0</b>
 * @date <2017-04-24 17:03>
 *
 */
public interface OpProdSkuAttributeDomain  extends BaseDomain<OpProdSkuAttributeInfo, OpProdSkuAttribute>{
	
	/**
	 * 保存属性
	 * @param opProdSkuAttribute
	 * @return
	 */
	int saveOpProdSkuAttribute(OpProdSkuAttribute opProdSkuAttribute);
	
	/**
	 * 保存属性 可选值
	 * @return
	 */
	int saveOpProdSkuAttributeLine(List<OpProdSkuAttributeLine>  lineList);
	
	/**
	 * 保存sku跟属性及可选值的关联关系
	 * @param relationList
	 * @return
	 */
	int saveOpProdSkuAttributeRelation(List<OpProdSkuAttributeRelation>  relationList);
	
	/**
	 * 商品属性列表查询
	 * @param cond
	 * @return
	 */
	List<OpProdSkuAttributeInfo> findByCond(OpProdSkuAttributeInfoCond cond);
	
	/**
	 * 查询单个属性
	 * @param Id
	 * @return
	 */
	OpProdSkuAttributeInfo findById(Integer id);
	
	/**
	 * 查询属性line
	 * @param attributeId
	 * @return
	 */
	List<OpProdSkuAttributeLine> findLineByAttributeId(Integer attributeId);
	
	
	void deleteByLineIds(List<Integer> lineIds);
	
	
	void approvalProdSkuAttributeVal(Integer attributeId, boolean isPass);
	
	int updateProdSkuAttribute(OpProdSkuAttribute opProdSkuAttribute);
	
	
	List<String> findAttributeNameByCategoryId(Integer categoryId);
	
	
	int deleAttributeById(Integer attributeId);
	
	int deleLineByAttributeId(Integer attributeId);
	
	List<OpProdSkuAttributeInfo> findAttributeAndLineByCategoryId(Integer categoryId, Integer lineStatus);
	
	
	int insertSkuAttributeRelation(OpProdSkuAttributeRelation relation);
	
	
	List<OpProdSkuAttributeLine> findLineByAttributeIdAndStatus(Integer attributeId, Integer lineStatus);
	
	
	
}
