package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;

import java.util.List;

/**
 * @author gongjun
 * @since 2017-01-04
 */
public interface CampaignDomain {

    /**
     * 获取全场非SKU维度活动
     * @return
     */
    List<PsCampaignVO> getGlobalCampaignList(PsMatchCampaignCond cond);

    /**
     * 获取匹配的活动
     * @param cond
     * @return
     */
    List<PsCampaignVO> getMatchedCampaignList(PsMatchCampaignCond cond);

    /**
     * 匹配商品列表活动
     * @param productVOList
     * @param cond
     */
    void matchListPageCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond cond);

    /**
     * 匹配商品活动
     * @param psProductVO
     * @param cond
     */
    void matchCampaigns(PsProductVO psProductVO, PsMatchCampaignCond cond);

    /**
     * 匹配SPV活动
     * @param spvVO
     * @param cond
     * @param crossBorderFlagValue
     */
    void matchCampaigns(PsSpvVO spvVO, PsMatchCampaignCond cond, Integer crossBorderFlagValue);

}
