package com.thebeastshop.pegasus.merchandise.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategoryExample;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategoryRelation;
import com.thebeastshop.pegasus.merchandise.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;

@Repository
public interface PcsSkuCategoryMapper {
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int countByExample(PcsSkuCategoryExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int deleteByExample(PcsSkuCategoryExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int deleteByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int insert(PcsSkuCategory record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int insertSelective(PcsSkuCategory record);

    int insertBackCategorySelective(PcsSkuCategory record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    List<PcsSkuCategory> selectByExample(PcsSkuCategoryExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    PcsSkuCategory selectByPrimaryKey(Long id);

    PcsSkuCategory selectBackCategoryByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int updateByExampleSelective(@Param("record") PcsSkuCategory record, @Param("example") PcsSkuCategoryExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int updateByExample(@Param("record") PcsSkuCategory record, @Param("example") PcsSkuCategoryExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int updateByPrimaryKeySelective(PcsSkuCategory record);

    int updateBackCategoryByPrimaryKeySelective(PcsSkuCategory record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_sku_category
     *
     * @mbggenerated Thu Jul 02 15:14:57 CST 2015
     */
    int updateByPrimaryKey(PcsSkuCategory record);

    int insertFrontCategoryRelation(PcsSkuCategoryRelation relation);

    int insertBackCategoryRelation(PcsSkuCategoryRelation relation);

    int insertFrontBackCategoryRelation(PcsFrontBackCategoryVO frontBackCategoryVO);

    int updateBackCategoryRelation(PcsSkuCategoryRelation relation);

    List<PcsFrontBackCategoryVO> findFrontBackCategory(Map<String, Object> params);

    List<PcsSkuCategory> findFrontCategory(Map<String, Object> params);

    List<PcsSkuCategory> findBackCategory(Map<String, Object> params);

    List<Long> findProductIdsBySkuCodes(Map<String, Object> params);

    List<Long> findProductIdListByCategoryFrontRelation(Map<String, Object> params);

    List<PcsSkuCategoryRelation> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond);

    List<Long> findFrontCategoryIdListByBackCategoryId(Long id);

    List<Long> findFrontCategoryIdListByBackCategoryIds(Map<String, Object> params);

    List<Long> findBackCategoryIdListByFrontCategoryId(Long id);

    int countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond);

    List<PcsSkuCategoryRelation> findBackCategoryRelation(PcsSkuCategoryRelationCond cond);

    Integer updateFrontCategoryRelation(PcsSkuCategoryRelation relation);

    int deleteFrontCategoryRelation(Map<String, Object> params);

    int deleteBackCategoryRelation(Map<String, Object> params);
    
    List<PcsSkuCategoryVO> findAllFirstBackCategoryList();

    List<PcsSkuCategoryVO> findRelationBackCategoryByFrontCategoryId(Long parentId);

    //=======================前台品类相关
    /**
     * 创建前台品类
     *
     * @param record
     * @return
     */
    Long insertFrontCategory(PcsSkuCategory record);

    /**
     * 更新前台品类
     *
     * @param record
     * @return
     */
    int updateFrontCategoryByPrimaryKeySelective(PcsSkuCategory record);

    /**
     * 根据前台类目id删除对应关系
     * @param frontId
     * @return
     */
    Integer deleteFrontBackCategoryRelationByFrontId(Long frontId);

    PcsSkuCategoryVO findFirstCategoryByParentId(Long id);

    List<PcsSkuCategoryVO> findCodePNameBySkuCodeList(List<String> list);

    List<PcsSkuCategoryVO> findCodeBySkuCodeList(List<String> list);

    List<Long> findByCondCategory(@Param("cond") PcsSkuCategoryCond cond);

    List<PcsSkuCategoryVO> findByCondCategoryCron(@Param("cond") PcsSkuCategoryCond cond);

    /**
     * 获取指定类目编号的叶子节点
     *
     * @param categoryIds
     *
     * @return
     */
    List<Long> listLeafCategoryId(List<Long> categoryIds);

    /**
     * 获取所有的叶子节点
     *
     * @return
     */
    List<PcsSkuCategory> listAllLeafCategory();

    /**
     * 获取指定编号的类目信息
     *
     * @param ids 类目编号集合
     *
     * @return
     */
    List<PcsSkuCategory> getCategoryByIds(List<Long> ids);

    List<PcsSkuCategoryVO> findCategoryByIds(@Param("cond") PcsSkuCategoryCond cond);

    PcsSkuCategory selectFrontCategoryByPrimaryKey(Long id);
}