package com.thebeastshop.pegasus.merchandise.dao;

import com.thebeastshop.pegasus.merchandise.cond.OpProductCond;
import com.thebeastshop.pegasus.merchandise.model.OpProduct;
import com.thebeastshop.pegasus.merchandise.model.OpProductExample;
import com.thebeastshop.pegasus.merchandise.vo.OpProductExcelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.OpTagVO;
import com.thebeastshop.pegasus.merchandise.vo.OpWatermarkVO;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface OpProductMapper {
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int countByExample(OpProductExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int deleteByExample(OpProductExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int deleteByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int insert(OpProduct record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int insertSelective(OpProduct record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    List<OpProduct> selectByExample(OpProductExample example);

    List<OpProduct> queryByIds(Map<String, Object> params);
    
    List<Long> findProductIdsByCampaignIds(Map<String, Object> params);

    List<Long> findProductIdsByCodes(Map<String, Object> params);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    OpProduct selectByPrimaryKey(Long id);

    /**
     * 通过code 查询product
     * @author lijing
     * @param code
     * @return
     */
    OpProduct selectByCode(String code);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int updateByExampleSelective(@Param("record") OpProduct record, @Param("example") OpProductExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int updateByExample(@Param("record") OpProduct record, @Param("example") OpProductExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int updateByPrimaryKeySelective(OpProduct record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_op_product
     *
     * @mbggenerated Tue Mar 22 20:20:41 CST 2016
     */
    int updateByPrimaryKey(OpProduct record);






    //self
    List<OpProduct> findByCriteria(OpProductCond cond);
    
    List<OpProduct> findBySkuCode(@Param(value = "skuCode") String skuCode); 

    List<OpProductExcelVO> findExportListByCriteria(OpProductCond cond);

	List<OpWatermarkVO> queryWatermarksByParams(Map<String, Object> params);
	
	List<OpTagVO> queryTagsByParams(Map<String, Object> params);

	List<Long> findProdWatermarkProdIdsByParams(Map<String, Object> params);

	List<Long> findProdTagProdIdsByParams(Map<String, Object> params);
	
	List<OpProduct> listProdMat(Map<String, Object> params);


	Map getBatchUpdateMapByCode(@Param("code") String code);


    /**
     * 查找指定商品的sku存在指定二级类目的个数
     *
     * @param productId 商品编号
     *
     * @param categoryIds 二级类目编号
     *
     * @return
     */
    Integer getSpecialCategoryByProductId(@Param("id") Long productId, @Param("list") List<Integer> categoryIds);

    /**
     * 查找指定商品的sku存在指定二级类目以外类目的个数
     * @param productId
     * @param categoryIds
     * @return
     */
    Integer getOtherCategoryByProductId(@Param("id") Long productId, @Param("list") List<Integer> categoryIds);


    /**
     * 根据product code或者name 查询非组合商品
     * @param arg0
     * @return
     */
    List<OpProduct> findNoCombinedProdByCodeOrName(@Param("arg0") String arg0);

    /**
     * 查找组合商品审核列表
     * @param cond
     * @return
     */
    List<OpProductVO> findCombinedProdAuditList(OpProductCond cond);

    /**
     * 根据活动编码获取活动编号
     * @param code
     * @return
     */
    Long getIdByCode(@Param("code") String code);

    /**
     * 查找指定的productCode是否存在非指定海淘类型的SKU的count
     * @param code
     * @param crossBorderFlag
     * @return
     */
    Integer getCrossBorderFlagListByCode(@Param("code") String code, @Param("crossBorderFlag") Integer crossBorderFlag);
}