package com.thebeastshop.pegasus.merchandise.conf;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.service.impl.McOpChannelServiceImpl;
import com.thebeastshop.pegasus.merchandise.util.DateUtils;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 鹿晗活动配置
 * @author gongjun
 * @since 2017-01-06
 */
@Component
public class LuhanConfig {
    private final static Logger LOGGER = LoggerFactory.getLogger(LuhanConfig.class);

    private PropertyConfigurer propertyConfigurer;

    /**
     * 参与的商品CODE列表
     */
    private List<String> prodCodes;

    /**
     * 开始起卖时间
     */
    private Date startTime;

    /**
     * 商品Map
     */
    private Map<String, Object> prodMap = new HashMap<>();

    public LuhanConfig(PropertyConfigurer propertyConfigurer) {
        this.propertyConfigurer = propertyConfigurer;
        this.reflush();
    }

    public List<String> getProdCodes() {
        return prodCodes;
    }

    public void setProdCodes(List<String> prodCodes) {
        this.prodCodes = prodCodes;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public boolean isLuhanProd(String code) {
        return prodMap.containsKey(code);
    }

    public synchronized void reflush() {
        String time = propertyConfigurer.getProperty("prod.luhan.start_time");
        startTime = DateUtil.parse(time, "yyyy-MM-dd hh:mm:ss");
        String codes = propertyConfigurer.getProperty("prod.luhan.codes");
        String[] codeArr = codes.split(",");
        prodCodes = Lists.newArrayList(codeArr);
        LOGGER.info("【鹿晗活动】刷新配置: 开始时间: {} 商品CODES: {}", startTime, StringUtils.join(codeArr, ","));

        prodMap = new HashMap<>();
        for (String code : prodCodes) {
            prodMap.put(code, true);
        }
    }


    public void setupProd(PsProductVO productVO) {
        if (isLuhanProd(productVO.getCode())) {
            Date now = new Date();
            if (now.before(startTime)) {
                LOGGER.info("【鹿晗商品】此为鹿晗商品[CODE: {}], 时间未到，设置未上架");
                productVO.setOnShelfChnCodes(new ArrayList<String>());
                productVO.setOffShelfChnCodes(new ArrayList<String>());
            }
        }
    }
}
