package com.thebeastshop.pegasus.merchandise.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>Title: thebeastshop</p>
 * <p>Copyright: Copyright (c) 2016</p>
 * @author Bryan Zhang
 * @date 2017-1-19
 * @description 日志
 */
public class ServiceAop {
	
	private final Logger log = LoggerFactory.getLogger(getClass());
	
	public Object doAround(ProceedingJoinPoint pJoinPoint) throws Throwable {
		try{
			Class clazz = pJoinPoint.getTarget().getClass();
			String className = clazz.getSimpleName();
	        String methodName = pJoinPoint.getSignature().getName();
			log.info("方法[{}.{}]开始调用",className, methodName);
			Object arg = null;
			StringBuilder argsBuilder = new StringBuilder("(");
			int argsLen = pJoinPoint.getArgs().length;
			try {
				for (int i = 0; i < argsLen; i++) {
					arg = pJoinPoint.getArgs()[i];
					int argIndex = i + 1;
					String argValue = getArgValue(arg);
					argsBuilder.append("参数" + argIndex + ": " + argValue);
					if (i < argsLen - 1) {
						argsBuilder.append(", ");
					}
					log.info("方法[{}.{}]参数{}:{}", className, methodName, argIndex, argValue);
				}
				argsBuilder.append(")");
				Cat.logEvent("PigeonService.args",
						className + "." + methodName,
						Message.SUCCESS,
						argsBuilder.toString());
			} catch (Exception e) {
				log.error("" + e);
			}
			long start = System.currentTimeMillis();
			Object result = pJoinPoint.proceed();
			// 添加Service元信息
			long end = System.currentTimeMillis();
			log.info("方法[{}.{}]结束调用,总共耗时{}毫秒",className,methodName,(end-start));
			return result;
		}catch(Throwable t){
			// 错误处理
			log.error("系统发生未知异常", t);
			throw t;
		}
	}


	private static String getArgValue(Object arg) {
		String argValue;
		if (arg == null) {
			return "null";
		}
		if (arg instanceof CharSequence) {
			return "\"" + arg.toString() + "\"";
		}
		if (int.class.isAssignableFrom(arg.getClass()) ||
				long.class.isAssignableFrom(arg.getClass()) ||
				short.class.isAssignableFrom(arg.getClass()) ||
				byte.class.isAssignableFrom(arg.getClass()) ||
				boolean.class.isAssignableFrom(arg.getClass())) {
			return String.valueOf(arg);
		}
		try {
			argValue = JSON.toJSONString(arg, SerializerFeature.DisableCircularReferenceDetect);
		} catch (Exception ex) {
			try {
				argValue = arg.getClass().getSimpleName() + " " + String.valueOf(arg);
			} catch (Exception ex2) {
				argValue = "null";
			}
		}
		return argValue;
	}
}
