package com.thebeastshop.pegasus.merchandise.enums;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * sku公司属性枚举
 * @author Gary
 *
 */
public enum PcsSkuCompanyAttrEnum {

	BEAST(1, "上海野派电子商务有限公司"),
	BUTUT(2, "布图日化（上海）有限公司"),
	BEAST_HK_CB(3, "Thebeastshop HK Limited-跨境"),         // cross border
    BEAST_HK_OP(4, "Thebeastshop HK Limited-海外加工"), // Overseas processing
    BLUE_LOVE(5,"上海布鲁爱电子商务有限公司");

	public final Integer status;
	public final String desc;

	public static final List<PcsSkuCompanyAttrEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private PcsSkuCompanyAttrEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(Integer status) {
        if (EmptyUtil.isEmpty(status)){
            return "";
        }
        for (PcsSkuCompanyAttrEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
