package com.thebeastshop.pegasus.merchandise.IService;

import java.util.List;

import com.thebeastshop.pegasus.merchandise.vo.ProdUpDownOperVO;
import com.thebeastshop.scm.po.ProductUpDownRecord;

public interface IProductUpDownRecordService {

	/**
	 * 上下架操作
	 * @param vo
	 */
	public void upDownOperation(ProdUpDownOperVO vo);
	
	/**
	 * 查询是否第一次上架
	 * @param canSaleProdId
	 * @return
	 */
	public Integer isFirstOnTheShelf(Integer canSaleProdId);

	/**
	 *  得到上下架记录
	 * @param chnCanSaleProdId 渠道可售产品表ID
	 * @return
	 */
	public List<ProductUpDownRecord> byChnCanSaleProdId(Integer chnCanSaleProdId);
	
	/**
	 * 审批上下架PROD
	 */
	public void updateProdApproval(ProdUpDownOperVO vo);
	
	/**
	 * 审批上下架PROD
	 */
	public void updateProdApprovalAndTimer(ProdUpDownOperVO vo);
}
