package com.thebeastshop.pegasus.merchandise.enums;


import com.thebeastshop.common.utils.EmptyUtil;

import java.util.*;

/**
 * sku公司属性枚举
 * @author Gary
 *
 */
public enum PcsSkuCompanyAttrEnum {

	BEAST(1, "野派","上海野派电子商务有限公司"),
	BUTUT(2, "布图","布图日化（上海）有限公司"),
	BEAST_HK_CB(3, "beast跨境", "Thebeastshop HK Limited-跨境"),         // cross border
    BEAST_HK_OP(4, "beast海外加工","Thebeastshop HK Limited-海外加工"), // Overseas processing
    BLUE_LOVE(5,"布鲁爱", "上海布鲁爱电子商务有限公司"),
	LOVE_BLUE(6,"艾布鲁", "上海艾布鲁信息科技有限公司"),
    BUYE_DAILY_CHEMICAL(7,"布野", "上海布野日化有限公司"),
	PUFF(8,"噗派", "上海噗派电子商务有限公司"),
	;


	public final Integer status;
	private final String shortName;
	public final String desc;

	public static final List<PcsSkuCompanyAttrEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PcsSkuCompanyAttrEnum(final Integer status, final String shortName, final String desc) {
		this.status = status;
		this.shortName = shortName;
		this.desc = desc;
	}

	public final static Integer getStatusByDesc(String companyDesc) {
		Integer statusVal = null;
    for (PcsSkuCompanyAttrEnum companyAttrEnum : values()) {
			if (companyAttrEnum.desc.equals(companyDesc)) {
        statusVal = companyAttrEnum.status;
				break;
			}
		}
		return statusVal;
	}

	public final static List<Map<String, Object>> listMapEnum() {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		for (PcsSkuCompanyAttrEnum skuCompanyAttrEnum : ALL) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("value", skuCompanyAttrEnum.status);
			map.put("name", skuCompanyAttrEnum.desc);
			list.add(map);
		}
		return list;
	}

	 // 普通方法
    public static String getDesc(Integer status) {
        if (EmptyUtil.isEmpty(status)){
            return "";
        }
        for (PcsSkuCompanyAttrEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public static String getShortName(Integer status) {
		if (EmptyUtil.isEmpty(status)){
			return "";
		}
		for (PcsSkuCompanyAttrEnum c : ALL) {
			if (c.getStatus() == status) {
				return c.shortName;
			}
		}
		return null;
	}


	public final static String[] arrayName() {
		int length = ALL.size();
		String[] result = new String[length];
		int arrayIndex = 0;
		for (PcsSkuCompanyAttrEnum companyAttrEnum : ALL) {
			result[arrayIndex] = companyAttrEnum.desc;
			arrayIndex ++;
		}
		return result;
	}
	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
