package com.thebeastshop.pegasus.merchandise.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * SKU BU 枚举
 */
public enum  PcsSkuBuEnum {
  TBH(1, "TBH"),
  HOME(2, "HOME"),
  MISS_BEAST(3, "MISS BEAST"),
  LITTLE_B(4, "LITTLE B"),
  BlingBling(5, "BlingBling"),
  Naked_Beast(6, "Naked Beast"),
  Buto(7, "Buto"),
  PACKAGING_MATERIAL(8, "包装耗材"),
  ENGINEERING_PROPS(9, "工程道具"),
  Naked_Beast_UW(10, "Naked Beast (UW)"),
  LOGISTICS_PROPS(11, "物流耗材");


  private final static PcsSkuBuEnum[] ALL = PcsSkuBuEnum.values();

  private Integer buVal;
  private String buName;

  PcsSkuBuEnum(Integer buVal, String buName) {
    this.buVal = buVal;
    this.buName = buName;
  }

  /**
   * 通过BU 名称获取 val
   * @param buName
   * @return
   */
  public final static Integer getBuValByName(String buName) {
    if (buName == null) {
      return null;
    }
    for (PcsSkuBuEnum buEnum : PcsSkuBuEnum.values()) {
      if (buName.equals(buEnum.buName)) {
        return buEnum.buVal;
      }
    }
    return null;
  }

  /**
   * 通过BU  val 获取Name
   * @param buVal
   * @return
   */
  public final static String getBuNameByVal(Integer buVal) {
    if (buVal == null) {
      return null;
    }
    for (PcsSkuBuEnum buEnum : PcsSkuBuEnum.values()) {
      if (buVal == buEnum.buVal) {
        return buEnum.buName;
      }
    }
    return null;
  }

  public final static List<Map<String, Object>> listMapEnum() {
    List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
    for (PcsSkuBuEnum skuCompanyAttrEnum : ALL) {
      Map<String, Object> map = new HashMap<String, Object>();
      map.put("value", skuCompanyAttrEnum.buVal);
      map.put("name", skuCompanyAttrEnum.buName);
      list.add(map);
    }
    return list;
  }

  public final static String[] arrayName() {
    int length = ALL.length;
    String[] result = new String[length];
    int arrayIndex = 0;
    for (PcsSkuBuEnum pcsSkuBuEnum : ALL) {
      result[arrayIndex] = pcsSkuBuEnum.buName;
      arrayIndex ++;
    }
    return result;
  }

  public static void main(String[] args) {
    arrayName();
  }



  public Integer getBuVal() {
    return buVal;
  }

  public String getBuName() {
    return buName;
  }

}
