package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 课程状态枚举
 * @author LK
 *
 */
public enum OpFrontCourseListStatusEnum {
	ENROLLED(1, "报名中"),
	ADVANCE(5, "预告"),
	REVIEW(9, "往期回顾")
	;

	public final Integer status;
	public final String desc;

	public static final List<OpFrontCourseListStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private OpFrontCourseListStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {

        for (OpFrontCourseListStatusEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
