package com.thebeastshop.pegasus.merchandise.enums;

import com.thebeastshop.common.utils.EmptyUtil;

import java.util.*;

/**
 * sku类型枚举
 * @author Gary
 *
 */
public enum PcsSkuTypeEnum {

	RAW_MATERIAL(1, "原材料"),
	SEMI_FINISHED_PRODUCT(2, "半成品"),
	FINISHED_PRODUCT(3, "成品");

	public final Integer status;
	public final String desc;

	public static final List<PcsSkuTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PcsSkuTypeEnum(final int status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	public final static List<Map<String, Object>> listMapEnum() {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		for (PcsSkuTypeEnum skuTypeEnum : ALL) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("value", skuTypeEnum.status);
			map.put("name", skuTypeEnum.desc);
			list.add(map);
		}
		return list;
	}

	 // 普通方法
    public static String getDesc(Integer status) {
		  if (status == null) {
        return  "";
			}
			for (PcsSkuTypeEnum c : ALL) {
					if (c.getStatus().equals(status)) {
							return c.desc;
					}
			}
			return null;
    }

	public static Integer getType(String desc) {
		if (EmptyUtil.isNotEmpty(desc)) {
			for (PcsSkuTypeEnum c : ALL) {
				if (c.desc.equals(desc)) {
					return c.status;
				}
			}
		}
		return null;
	}

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
