package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.commdata.enums.WayTypeEnum;
import com.thebeastshop.commdata.vo.CommCityVO;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.YesOrNoEnum;
import com.thebeastshop.wms.vo.WhPhysicalWarehouseVO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class OpChannelVO implements Serializable {
    public static final String REDIS_CHANNEL_CODE_WAY_TYPE = "CHANNEL_CODE_WAY_TYPE";
    public static final String REDIS_CHANNEL_NAME_WAY_TYPE = "CHANNEL_NAME_WAY_TYPE";
    public static final int REDIS_CHANNEL_DB_IDX = 0;
    private static Integer CHANNEL_STATUS_OPEN = 1;
    private static Integer CHANNEL_STATUS_CLOSE = -1;
    List<OpChannelServiceLineVO> opChannelServiceLineVOs;
    List<Integer> serviceLineIds;
    private Long id;
    /**
     * 渠道编码
     */
    private String code;
    // 用于接收前台传递，绑定业务线时使用
    private String channelCode;
    /**
     * 渠道名
     */
    private String name;
    /**
     * 渠道类型，1线下2线上
     */
    private Integer channelType;
    /**
     * 所属平台-1：线上、2：普通门店 3：Little B门店 4、其他
     */
    private Integer wayType;
    private String wayTypeStr;
    /**
     * 销售仓
     */
    private String warehouseForSales;
    private String warehouseForSalesName;
    /**
     * 创建时间
     */
    private Date createTime;
    //电商平台
    private String commercePlatform;
    /**
     * 售后电话
     */
    private String servicePhone;
    /**
     * 邮件通知地址
     * ‘；’分割
     */
    private String noticeEmails;
    private String warehouseForSalesOther;
    // 业务线
    private String serviceLineStr;
    private Integer serviceLine;
    private Integer type;
    private Integer changeDifferentSku;				// 是否支持不同sku换货（1支持0不支持）
    private Integer changeDifferentPriceSku;		// 是否支持不同价格sku换货（1支持0不支持）
    private Integer editDifferrntPrice;				// 是否支持换货sku修改差价（1支持0不支持）
    private Integer differrntPriceSubmit;			// 差价是否可以提交（0有差价无法提交、1有差价符合限额才可提交、2有差价均可提交）
    private BigDecimal differentPriceQuota;         // 换货差价限额 默认为0，正数，两位小数，单位%
    private Integer differentPriceCalculateWay;     // 换货差价计算方式 1.计算折扣明细、2.仅计算售价
    private Integer exchangeUndercarriageSku;       // 是否可换下架sku（1支持0不支持）
    private Integer hasAutoDistribution;
    private Integer distributionMode;
    private Integer deliveryHour;
    private Date openTime;                          // 开店时间
    private Date closeTime;                         // 关店时间
    private Integer channelStatus;                  // 渠道状态（状态（-1禁用，1可用））
    private Integer regionalManager;
    private Integer supervisor;
    private Long cityId;

    private String cityName;
    private Integer channelFlowerType;

    private Integer channelHomeType;

    private Integer storeAllotLimitPreWeek;
    //剩余预算金额
    private BigDecimal storeAllotBudgetPreMonth;
    private String physicalWarehouseCode;
    private CommCityVO cityVO;
    private WhPhysicalWarehouseVO whPhysicalWarehouseVO;

    private Integer channelBuType;

    //是否支持拆单发货
    private Integer supportSplitOrder = YesOrNoEnum.NO.id;

    private Long bigAreaId;
    private List<OpChannelVO> opChannelVOList;
    //企微账户
    private List<OpChannelQwAccountVO> qwAccountList;
    //发货时效
    private List<OpChannelDeliveryVO> deliveryTimeList;
    private Integer companyId;
    private boolean selective = true;

    public Integer getWayType() {
		return wayType;
	}

	public void setWayType(Integer wayType) {
		this.wayType = wayType;
	}

    public String getWayTypeStr() {
        return wayTypeStr;
    }

    public void setWayTypeStr(String wayTypeStr) {
        this.wayTypeStr = wayTypeStr;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public CommCityVO getCityVO() {
        return cityVO;
    }

    public Integer getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(Integer supervisor) {
        this.supervisor = supervisor;
    }

    public Integer getRegionalManager() {
        return regionalManager;
    }

    public void setRegionalManager(Integer regionalManager) {
        this.regionalManager = regionalManager;
    }

    public void setCityVO(CommCityVO cityVO) {
        this.cityVO = cityVO;
    }

    public List<OpChannelVO> getOpChannelVOList() {
        return opChannelVOList;
    }

    public void setOpChannelVOList(List<OpChannelVO> opChannelVOList) {
        this.opChannelVOList = opChannelVOList;
    }

    public WhPhysicalWarehouseVO getWhPhysicalWarehouseVO() {
        return whPhysicalWarehouseVO;
    }

    public void setWhPhysicalWarehouseVO(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        this.whPhysicalWarehouseVO = whPhysicalWarehouseVO;
    }

    public String getCommercePlatform() {
        return commercePlatform;
    }

    public void setCommercePlatform(String commercePlatform) {
        this.commercePlatform = commercePlatform;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getChannelType() {
        return channelType;
    }

    public Long getCityId() {
        return cityId;
    }

    public void setCityId(Long cityId) {
        this.cityId = cityId;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public String getWarehouseForSales() {
        return warehouseForSales;
    }

    public void setWarehouseForSales(String warehouseForSales) {
        this.warehouseForSales = warehouseForSales;
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public String getWarehouseForSalesName() {
        return warehouseForSalesName;
    }

    public void setWarehouseForSalesName(String warehouseForSalesName) {
        this.warehouseForSalesName = warehouseForSalesName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public String getNoticeEmails() {
        return noticeEmails;
    }

    public void setNoticeEmails(String noticeEmails) {
        this.noticeEmails = noticeEmails;
    }

    public String getWarehouseForSalesOther() {
        return warehouseForSalesOther;
    }

    public void setWarehouseForSalesOther(String warehouseForSalesOther) {
        this.warehouseForSalesOther = warehouseForSalesOther;
    }

    public String getServiceLineStr() {
        return serviceLineStr;
    }

    public void setServiceLineStr(String serviceLineStr) {
        this.serviceLineStr = serviceLineStr;
    }

    public Integer getServiceLine() {
        return serviceLine;
    }

    public void setServiceLine(Integer serviceLine) {
        this.serviceLine = serviceLine;
    }

    public List<OpChannelServiceLineVO> getOpChannelServiceLineVOs() {
        return opChannelServiceLineVOs;
    }

    public void setOpChannelServiceLineVOs(List<OpChannelServiceLineVO> opChannelServiceLineVOs) {
        this.opChannelServiceLineVOs = opChannelServiceLineVOs;
    }

    public List<Integer> getServiceLineIds() {
        return serviceLineIds;
    }

    public void setServiceLineIds(List<Integer> serviceLineIds) {
        this.serviceLineIds = serviceLineIds;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    
    

    public Integer getChangeDifferentSku() {
		return changeDifferentSku;
	}

	public void setChangeDifferentSku(Integer changeDifferentSku) {
		this.changeDifferentSku = changeDifferentSku;
	}

	public Integer getChangeDifferentPriceSku() {
		return changeDifferentPriceSku;
	}

	public void setChangeDifferentPriceSku(Integer changeDifferentPriceSku) {
		this.changeDifferentPriceSku = changeDifferentPriceSku;
	}

	public Integer getEditDifferrntPrice() {
		return editDifferrntPrice;
	}

	public void setEditDifferrntPrice(Integer editDifferrntPrice) {
		this.editDifferrntPrice = editDifferrntPrice;
	}

	public Integer getDifferrntPriceSubmit() {
		return differrntPriceSubmit;
	}

	public void setDifferrntPriceSubmit(Integer differrntPriceSubmit) {
		this.differrntPriceSubmit = differrntPriceSubmit;
	}

    public BigDecimal getDifferentPriceQuota() {
        return differentPriceQuota;
    }

    public void setDifferentPriceQuota(BigDecimal differentPriceQuota) {
        this.differentPriceQuota = differentPriceQuota;
    }

    public Integer getDifferentPriceCalculateWay() {
        return differentPriceCalculateWay;
    }

    public void setDifferentPriceCalculateWay(Integer differentPriceCalculateWay) {
        this.differentPriceCalculateWay = differentPriceCalculateWay;
    }

    public Integer getExchangeUndercarriageSku() {
        return exchangeUndercarriageSku;
    }

    public void setExchangeUndercarriageSku(Integer exchangeUndercarriageSku) {
        this.exchangeUndercarriageSku = exchangeUndercarriageSku;
    }


    public Integer getHasAutoDistribution() {
        return hasAutoDistribution;
    }

    public void setHasAutoDistribution(Integer hasAutoDistribution) {
        this.hasAutoDistribution = hasAutoDistribution;
    }

    public Integer getDistributionMode() {
        return distributionMode;
    }

    public void setDistributionMode(Integer distributionMode) {
        this.distributionMode = distributionMode;
    }

    public Integer getDeliveryHour() {
        return deliveryHour;
    }

    public void setDeliveryHour(Integer deliveryHour) {
        this.deliveryHour = deliveryHour;
    }

    public Date getOpenTime() {
        return openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Integer getChannelStatus() {
        return channelStatus;
    }

    public void setChannelStatus(Integer channelStatus) {
        this.channelStatus = channelStatus;
    }

    public Integer getChannelFlowerType() {
        return channelFlowerType;
    }

    public void setChannelFlowerType(Integer channelFlowerType) {
        this.channelFlowerType = channelFlowerType;
    }

    public Integer getChannelHomeType() {
        return channelHomeType;
    }

    public void setChannelHomeType(Integer channelHomeType) {
        this.channelHomeType = channelHomeType;
    }

    public Integer getStoreAllotLimitPreWeek() {
        return storeAllotLimitPreWeek;
    }

    public void setStoreAllotLimitPreWeek(Integer storeAllotLimitPreWeek) {
        this.storeAllotLimitPreWeek = storeAllotLimitPreWeek;
    }

    public BigDecimal getStoreAllotBudgetPreMonth() {
        return storeAllotBudgetPreMonth;
    }

    public void setStoreAllotBudgetPreMonth(BigDecimal storeAllotBudgetPreMonth) {
        this.storeAllotBudgetPreMonth = storeAllotBudgetPreMonth;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Integer getSupportSplitOrder() {
        return supportSplitOrder;
    }

    public void setSupportSplitOrder(Integer supportSplitOrder) {
        this.supportSplitOrder = supportSplitOrder;
    }

    /**
     * 订单类型
     *
     * @return
     */
    public String getChannelStatusName() {
        return channelStatus == null ? "" :
                       channelStatus.equals(CHANNEL_STATUS_OPEN) ? "正常" :
                               channelStatus.equals(CHANNEL_STATUS_CLOSE)?"已关闭":"";
    }

    public String getWayTypeName() {
        return wayType == null ? "" :
                       AccessWayEnum.getNameByCode(wayType) == null?"":AccessWayEnum.getNameByCode(wayType);
    }

    public Integer getChannelBuType() {
        return channelBuType;
    }

    public void setChannelBuType(Integer channelBuType) {
        this.channelBuType = channelBuType;
    }

    public Long getBigAreaId() {
        return bigAreaId;
    }

    public void setBigAreaId(Long bigAreaId) {
        this.bigAreaId = bigAreaId;
    }

    public List<OpChannelQwAccountVO> getQwAccountList() {
        return qwAccountList;
    }

    public void setQwAccountList(List<OpChannelQwAccountVO> qwAccountList) {
        this.qwAccountList = qwAccountList;
    }

    public List<OpChannelDeliveryVO> getDeliveryTimeList() {
        return deliveryTimeList;
    }

    public void setDeliveryTimeList(List<OpChannelDeliveryVO> deliveryTimeList) {
        this.deliveryTimeList = deliveryTimeList;
    }

    public Integer getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Integer companyId) {
        this.companyId = companyId;
    }

    public boolean isSelective() {
        return selective;
    }

    public void setSelective(boolean selective) {
        this.selective = selective;
    }

    /**
     * 如果对象类型是User 的话 则返回true 去比较hashCode值
     */
    @Override
    public boolean equals(Object obj) {
        if(obj == null) return false;
        if(this == obj) return true;
        if(obj instanceof OpChannelVO){
            OpChannelVO user =(OpChannelVO)obj;
//          if(user.id = this.id) return true; // 只比较id
            // 比较id和username 一致时才返回true 之后再去比较 hashCode
            if(user.id == this.id && user.name.equals(this.name)) return true;
        }
        return false;
    }



    /**
     * 重写hashcode 方法，返回的hashCode 不一样才认定为不同的对象
     */
    @Override
    public int hashCode() {
//      return id.hashCode(); // 只比较id，id一样就不添加进集合
        return id.hashCode() * name.hashCode();
    }
}