package com.thebeastshop.pegasus.merchandise.enums;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2019/8/14 11:49
 * 人工推荐选购页
 */
public enum BrandStatusEnum {

    UNAUDIT(0, "待提交"), MANAGE_APPROVAL(1, "待品类经理审批"), LAW_APPROVAL(2, "待法务审"), REJECT(-1, "驳回"), FINISHED(3, "审批完成");

    public Integer value;
    public String cn;

    private BrandStatusEnum(Integer value, String cn){
        this.value = value;
        this.cn = cn;
    }

    public static Map<Integer, String> getMap(){
        Map<Integer, String> result = new LinkedHashMap<>();
        for (BrandStatusEnum status : BrandStatusEnum.values()) {
            result.put(status.value, status.cn);
        }
        return result;
    }


}
