package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.pegasus.merchandise.cond.OpSpvCond;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:26
 */
public interface McOpSpvService {
    Long create(OpSpvVO prodSku);
    boolean update(OpSpvVO prodSku);
    Long createOrUpdate(OpSpvVO prodSku);
    boolean deleteById(Long id);
    boolean deleteByProdId(Long prodId);
    List<OpSpvVO> findByProdId(Long prodId);
    List<OpSpvVO> findByProdIds(List<Long> prodIds);
    List<OpSpvVO> findBySkuCode(String skuCode);
    Integer getProductIdByskuCode(String skuCode);
    List<OpSpvVO> findAll();
    List<String> getALLSkuCode();
    List<OpSpvVO> findByPcsProdSkuCond(OpSpvCond opSpvCond);
    Map<String, List<OpSpvVO>> mapBySkuCodes(List<String> skuCodes);
    Boolean getSpvById(Long id);
    List<Long> getProductIdsBySkucodes(List<String> skuCodes);

    List<OpSpvVO> getCombinedSpvBySkucodes(List<String> skuCodes);

    Integer queryTotalOnChnCount();
    Integer queryNewOnChnCount(Date createTime);
    List<String> findSpvTempGroupNameCombinedByProdId(Long prodId);

    Boolean isSameGroupProd(Long prodId,Long spvId,String skuCode,String newSkuCode);
}
