package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.math.BigDecimal;

import com.thebeastshop.pegasus.merchandise.enums.PriceCalTypeEnum;

/**
 * 价格计算结果
 * 
 * @author Paul-xiong
 *
 */
public class PriceCalResultVO implements Serializable{
	private static final long serialVersionUID = 7269390392696638713L;
	/**
	 * 价格计算类型
	 */
	private PriceCalTypeEnum type;
	/**
	 * 价格计算相关的ID 价格类型：会员折扣 --> 会员ID 价格类型：活动类型 --> 活动ID 价格类型：优惠券类型 --> 优惠券ID
	 */
	private Long extId;
	/**
	 * 计算前价格
	 */
	private BigDecimal originalPrice;
	/**
	 * 计算后价格
	 */
	private BigDecimal finalPrice;

	public PriceCalTypeEnum getType() {
		return type;
	}

	public void setType(PriceCalTypeEnum type) {
		this.type = type;
	}

	public BigDecimal getOriginalPrice() {
		return originalPrice;
	}

	public void setOriginalPrice(BigDecimal originalPrice) {
		this.originalPrice = originalPrice;
	}

	public BigDecimal getFinalPrice() {
		return finalPrice;
	}

	public void setFinalPrice(BigDecimal finalPrice) {
		this.finalPrice = finalPrice;
	}

	public Long getExtId() {
		return extId;
	}

	public void setExtId(Long extId) {
		this.extId = extId;
	}

}
