package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.DiscountTypeEnum;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.exception.OperationExceptionErrorCode;
import org.apache.commons.collections.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-07-15
 */
public class PsCampaignVO extends PsBaseVO {

    private Long id;

    private String code;

    private String name;

    private String title;

    private Integer state;

    private Integer active;

    /**
     * 商品范围。1=单品；2=多品；3=全场
     */
    private Integer productScopeId;

    /**
     * 折扣类型。1=打折；2=满减；3=买赠；4=加价购
     */
    private Integer discountTypeId;

    private String discountTypeName;

    private Integer crossBorderFlag;

    private List<Integer> accessWayIds;

    private List<Integer> memberLevels;

    private List<Integer> buIds;

    // 16 bytes
    transient private byte[] accessWayArray = new byte[] {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // 16 bytes
    transient private byte[] memberLevelArray = new byte[] {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private List<PsCampaignSectionVO> campaignSectionList;

    private Integer cumulative;

    private Date createTime;

    private Date startTime;

    private Date expireTime;

    private Integer approvalState;
    private Integer advance;                            // 是否预告
    private String advanceName;                         // 预告名称
    private String advanceTitle;                        // 预告文案
    private Date advanceStartTime;                      // 预告开始时间
    private Date advanceEndTime;                        // 预告结束时间
    private String advancePriceTitle;                   // 预告价格文案
    private Integer limitAmount;                        // 人均限购数量
    private Integer panicBuyAmount;                     // 抢购总数
    private Integer optionFlag;                         // 任选对象:0.可以针对同一商品 1.不可针对同一商品
    private Integer ladderRule;                         // 阶梯参与规则 1.满足多阶梯可同时参与 2.满足多阶梯只参与最高阶梯
    private Integer level;                              // 价格折扣活动优先级
    private String imageUrl;                            //活动图片
    private Integer groupNumber;                       //团购成团人数，几人成团
    private Integer minUnit;                           //团购件数，每人买几件
    private String object;                             //参加对象 all：全部、firstBuy:首单用户
    private String shareImageUrl;                     //分享图片
    private String friendShareImageUrl;              //朋友圈分享图片
    private String statusShareTitle;                 //分享状态文案
    private String merchDetailShareTitle;            //商品详情分享文案
    private String memberType;                        //01新人专享活动 00普通折扣活动
    /**
     * 排除的线下门店
     */
    private List<String> excludeStores;

    /**
     * 排除的商品编号集合
     */
    private List<Long> excludeProductIds;

    /**
     * 排除的SKU编码集合
     */
    private List<String> excludeSukCodes;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getProductScopeId() {
        return productScopeId;
    }

    public void setProductScopeId(Integer productScopeId) {
        this.productScopeId = productScopeId;
    }

    public Integer getDiscountTypeId() {
        return discountTypeId;
    }

    public void setDiscountTypeId(Integer discountTypeId) {
        this.discountTypeId = discountTypeId;
    }

    public String getDiscountTypeName() {
        return discountTypeName;
    }

    public void setDiscountTypeName(String discountTypeName) {
        this.discountTypeName = discountTypeName;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public List<Integer> getAccessWayIds() {
        return accessWayIds;
    }

    public void setAccessWayIds(List<Integer> accessWayIds) {
        this.accessWayIds = accessWayIds;
        if (accessWayIds != null) {
            for (int index : accessWayIds) {
                if (index >= 0 && index <= 19) {
                    accessWayArray[index] = 1;
                }
            }
        }
    }

    public List<Integer> getMemberLevels() {
        return memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
        if (memberLevels != null) {
            for (int index : memberLevels) {
                if (index >= -1 && index <= 8) {
                    memberLevelArray[index + 1] = 1;
                }
            }
        }

    }

    /**
     * 活动基础数据匹配
     *
     * @param accessWay 适用平台
     *
     * @param memberLevel 会员等级
     *
     * @param crossBorderFlag 贸易类型
     *
     * @param channelCode 交易渠道
     *
     * @return
     */
    private Boolean matchBase(Integer accessWay, Integer memberLevel, Boolean crossBorderFlag, String channelCode) {
        if (accessWay > 19 || accessWay < 0 || memberLevel > 8 || memberLevel < -1) {
            return false;
        }

        // 排除非上线状态活动
        if (state == null || !state.equals(1)) {
            return false;
        }

        if (this.crossBorderFlag == null) {
            throw new OperationException(OperationExceptionErrorCode.ILLEGAL_PARAM);
        }

        // 贸易类型非不限制且商品贸易类型和活动贸易类型不一致
        if (this.crossBorderFlag != -1 && !this.crossBorderFlag.equals(crossBorderFlag ? 1 : 0)) {
            return false;
        }

        // 如果是非海淘商品，排除海淘活动
        /*if (this.crossBorderFlag != null && this.crossBorderFlag.equals(1) && !crossBorderFlag) {
            return false;
        }*/

        // 如果是海淘商品，排除非海淘活动
        /*if ((this.crossBorderFlag == null || this.crossBorderFlag.equals(0)) && crossBorderFlag) {
            return false;
        }*/

        // 匹配平台
        if (accessWayArray[accessWay] == 0 && !accessWayIds.contains(accessWay)) {
            return false;
        }

        // 匹配会员等级
        if (memberLevelArray[memberLevel + 1] == 0 && !memberLevels.contains(memberLevel)) {
            return false;
        }

        // 匹配是否为排除线下门店
        if (CollectionUtils.isNotEmpty(excludeStores) && excludeStores.contains(channelCode)) {
            return false;
        }
        return true;
    }

    /**
     * 匹配活动
     * @param accessWay
     * @param memberLevel
     * @return
     */
    public Boolean match(Integer accessWay, Integer memberLevel, Boolean crossBorderFlag, String channelCode) {
        Boolean matchBase = matchBase(accessWay, memberLevel, crossBorderFlag, channelCode);
        if (!matchBase) {
            return false;
        }

        // 排除不在有效期内活动
        if (startTime != null && expireTime != null) {
            Date now = new Date();
            if (now.before(startTime) || now.after(expireTime)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 判断是否匹配预告活动
     * @param accessWay
     * @param memberLevel
     * @param crossBorder
     * @return
     */
    public Boolean isMatchAdvance(Integer accessWay, Integer memberLevel, Boolean crossBorder, String channelCode) {

        // 排除非预告活动
        if(this.advance == null || this.advance != 1) {
            return false;
        }

        Boolean matchBase = matchBase(accessWay, memberLevel, crossBorder, channelCode);
        if (!matchBase) {
            return false;
        }

        // 排除预告时间不在有效期内活动
        if (advanceStartTime != null && advanceEndTime != null) {
            Date now = new Date();
            if (now.before(advanceStartTime) || now.after(advanceEndTime)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 判断是否为sku维度活动
     *
     * @return
     */
    public Boolean isSkuCampaign() {
        return (DiscountTypeEnum.OFF.getId().equals(discountTypeId) || DiscountTypeEnum.PANIC_BUY.getId().equals(discountTypeId));
    }

    public List<PsCampaignSectionVO> getCampaignSectionList() {
        return campaignSectionList;
    }

    public void setCampaignSectionList(List<PsCampaignSectionVO> campaignSectionList) {
        this.campaignSectionList = campaignSectionList;
    }

    public Integer getCumulative() {
        return cumulative;
    }

    public void setCumulative(Integer cumulative) {
        this.cumulative = cumulative;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getApprovalState() {
        return approvalState;
    }

    public void setApprovalState(Integer approvalState) {
        this.approvalState = approvalState;
    }

    public Integer getAdvance() {
        return advance;
    }

    public void setAdvance(Integer advance) {
        this.advance = advance;
    }

    public String getAdvanceName() {
        return advanceName;
    }

    public void setAdvanceName(String advanceName) {
        this.advanceName = advanceName;
    }

    public String getAdvanceTitle() {
        return advanceTitle;
    }

    public void setAdvanceTitle(String advanceTitle) {
        this.advanceTitle = advanceTitle;
    }

    public Date getAdvanceStartTime() {
        return advanceStartTime;
    }

    public void setAdvanceStartTime(Date advanceStartTime) {
        this.advanceStartTime = advanceStartTime;
    }

    public Date getAdvanceEndTime() {
        return advanceEndTime;
    }

    public void setAdvanceEndTime(Date advanceEndTime) {
        this.advanceEndTime = advanceEndTime;
    }

    public String getAdvancePriceTitle() {
        return advancePriceTitle;
    }

    public void setAdvancePriceTitle(String advancePriceTitle) {
        this.advancePriceTitle = advancePriceTitle;
    }
    @Override
    public boolean equals(Object obj) {
        if(obj != null && obj instanceof PsCampaignVO) {
            PsCampaignVO that = (PsCampaignVO) obj;
            return (this.id != null && this.id.equals(that.getId()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Integer getLimitAmount() {
        return limitAmount;
    }

    public void setLimitAmount(Integer limitAmount) {
        this.limitAmount = limitAmount;
    }

    public Integer getPanicBuyAmount() {
        return panicBuyAmount;
    }

    public void setPanicBuyAmount(Integer panicBuyAmount) {
        this.panicBuyAmount = panicBuyAmount;
    }

    public Integer getOptionFlag() {
		return optionFlag;
	}

	public void setOptionFlag(Integer optionFlag) {
		this.optionFlag = optionFlag;
	}

    public Integer getLadderRule() {
        return ladderRule;
    }

    public void setLadderRule(Integer ladderRule) {
        this.ladderRule = ladderRule;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public List<Long> getExcludeProductIds() {
        return excludeProductIds;
    }

    public void setExcludeProductIds(List<Long> excludeProductIds) {
        this.excludeProductIds = excludeProductIds;
    }

    public List<String> getExcludeSukCodes() {
        return excludeSukCodes;
    }

    public void setExcludeSukCodes(List<String> excludeSukCodes) {
        this.excludeSukCodes = excludeSukCodes;
    }

    public List<String> getExcludeStores() {
        return excludeStores;
    }

    public void setExcludeStores(List<String> excludeStores) {
        this.excludeStores = excludeStores;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Integer getGroupNumber() {
        return groupNumber;
    }

    public void setGroupNumber(Integer groupNumber) {
        this.groupNumber = groupNumber;
    }

    public Integer getMinUnit() {
        return minUnit;
    }

    public void setMinUnit(Integer minUnit) {
        this.minUnit = minUnit;
    }

    public String getObject() {
        return object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getShareImageUrl() {
        return shareImageUrl;
    }

    public void setShareImageUrl(String shareImageUrl) {
        this.shareImageUrl = shareImageUrl;
    }

    public String getStatusShareTitle() {
        return statusShareTitle;
    }

    public void setStatusShareTitle(String statusShareTitle) {
        this.statusShareTitle = statusShareTitle;
    }

    public String getMerchDetailShareTitle() {
        return merchDetailShareTitle;
    }

    public void setMerchDetailShareTitle(String merchDetailShareTitle) {
        this.merchDetailShareTitle = merchDetailShareTitle;
    }

    public List<Integer> getBuIds() {
        return buIds;
    }

    public void setBuIds(List<Integer> buIds) {
        this.buIds = buIds;
    }

    public String getFriendShareImageUrl() {
        return friendShareImageUrl;
    }

    public void setFriendShareImageUrl(String friendShareImageUrl) {
        this.friendShareImageUrl = friendShareImageUrl;
    }

    public String getMemberType() {
        return memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public Integer getActive() {
        return active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }
}
