package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCmSplVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomMadeVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCustomMadeSupplier.java, v 0.1 2015-08-06 13:05
 */
public interface McPcsSkuCmSplService {

    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    Long create(PcsSkuCmSplVO record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuCmSplVO record);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsSkuCmSplVO findById(long id);

    /**
     * 根据sku定制单号查找实体
     *
     * @param skuCustomMadeId
     * @return
     */
    List<PcsSkuCmSplVO> findBySkuCustomMadeId(long skuCustomMadeId);

    /**
     * 根据ID删除实体
     *
     * @param id
     * @return
     */
    boolean deleteById(long id);


}
