package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * sku状态枚举
 * @author Gary
 *
 */
public enum IposProdStatusEnum {

	NO_CHANNAL(1, "无渠道"),
	NO_ONSHELF(2, "未上架"),
	NO_SEE(3, "不可见"),
	NO_SALE(4, "不可售");

	public final Integer status;
	public final String desc;

	public static final List<IposProdStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private IposProdStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {

        for (IposProdStatusEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
