package com.thebeastshop.pegasus.merchandise.IService;

import java.util.List;

import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.scm.po.Recommend;
import com.thebeastshop.scm.po.RecommendProductAuto;
import com.thebeastshop.scm.vo.recommend.RecommendParamVO;
import com.thebeastshop.scm.vo.recommend.OrderFinishRecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendAutoListVO;
import com.thebeastshop.scm.vo.recommend.RecommendAutoProdSaveVO;
import com.thebeastshop.scm.vo.recommend.RecommendEditVO;
import com.thebeastshop.scm.vo.recommend.RecommendSaveVO;

/**
 * 商品推荐接口
 * @author donghui
 */
public interface IRecommendService {
	List<Recommend> list();
	
	RecommendEditVO edit(Integer recommendId);
	
	void save(RecommendSaveVO vo);
	
	void saveAutoProd(RecommendAutoProdSaveVO vo);
	
	List<RecommendAutoListVO> autoList(RecommendProductAuto.Position Position, RecommendProductAuto.Type type, String sourceProductCode);
	

	List<RecommendAutoListVO> addOnItemList(Integer pagenum);
	
	List<RecommendAutoListVO> prodDetailsList(String productCode);
	
	
	//以下为前台页面接口调用
	
	/**
	 * 得到购物车位置的推荐商品/个人中心/帖子详情
	 * @param paramVO
	 * @return
	 */
	List<PsProductVO> getShoppingCartProcutList(RecommendParamVO paramVO);
	
	/**
	 * 自动推荐(商品详细推荐/晒单推荐)
	 * 免邮凑单推荐已经废弃
	 */
	List<PsProductVO> autoRecommend(RecommendParamVO paramVO);
	
	/**
	 * 订单完成页自动推荐/订单详情/购买成功/物流详情
	 */
	List<PsProductVO> orderFinishRecommend(OrderFinishRecommendParamVO paramVO);

	/**
	 * 自动推荐(个人中心推荐)
	 */
//	List<PsProductVO> memberCenterRecommend(RecommendParamVO paramVO);
	
}