package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.ProduceTaskStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Desc:待创建任务的VO类
 * Created by hafiz.zhang on 2016/8/19.
 */
public class OpProduceTaskVO implements Serializable {
    private Long id;                                    //记录编号
    private String orderCode;                           //订单编号
    private String packageCode;                         //包裹编号
    private String srcChannelCode;                      //来源渠道编码
    private String desChannelCode;                      //目的渠道编码
    private ProduceTaskStatusEnum produceTaskStatus;    //任务状态
    private Long creatorId;                             //创建者编号
    private Date createTime;                            //创建时间
    private Date updateTime;                            //最后更新时间

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    public String getSrcChannelCode() {
        return srcChannelCode;
    }

    public void setSrcChannelCode(String srcChannelCode) {
        this.srcChannelCode = srcChannelCode;
    }

    public String getDesChannelCode() {
        return desChannelCode;
    }

    public void setDesChannelCode(String desChannelCode) {
        this.desChannelCode = desChannelCode;
    }

    public ProduceTaskStatusEnum getProduceTaskStatus() {
        return produceTaskStatus;
    }

    public void setProduceTaskStatus(ProduceTaskStatusEnum produceTaskStatus) {
        this.produceTaskStatus = produceTaskStatus;
    }

    public Long getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String toString() {
        return "OpProduceTaskVO{" +
                "id=" + id +
                ", orderCode='" + orderCode + '\'' +
                ", packageCode='" + packageCode + '\'' +
                ", srcChannelCode='" + srcChannelCode + '\'' +
                ", desChannelCode='" + desChannelCode + '\'' +
                ", produceTaskStatus=" + produceTaskStatus +
                ", creatorId=" + creatorId +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                '}';
    }

    /**
     * convert OpProduceTaskVO to OpProduceTask
     *
     * @return
     */
/*
    public OpProduceTask convert2OpProduceTask(){
        OpProduceTaskImpl domain = new OpProduceTaskImpl();
        domain.setId(this.id);
        domain.setOrderCode(this.orderCode);
        domain.setPackageCode(this.packageCode);
        domain.setSrcChannelCode(this.srcChannelCode);
        domain.setDesChannelCode(this.desChannelCode);
        domain.setProduceTaskStatus(this.produceTaskStatus);
        domain.setCreatorId(this.creatorId);
        domain.setCreateTime(this.createTime);
        domain.setUpdateTime(this.updateTime);
        return domain;
    }
*/

    /**
     * convert OpProduceTaskVO list to OpProduceTask list
     *
     * @param vos wait for convert list
     *
     * @return
     */
/*
    public static List<OpProduceTask> convert2OpProduceTaskList(List<OpProduceTaskVO> vos){
        if(CollectionUtils.isEmpty(vos)) {
            return null;
        }
        List<OpProduceTask> list = Lists.newArrayList();
        for (OpProduceTaskVO vo : vos) {
            list.add(vo.convert2OpProduceTask());
        }
        return list;
    }
*/
}
