package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import com.thebeastshop.pegasus.merchandise.cond.ApprovalRecordCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuQualifyCond;
import com.thebeastshop.pegasus.merchandise.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQualifyVO;

public interface McPcsSkuQualifyService {


	/**
     * 创建SKU资质审批
     * @param vo
     * @return
     */
    Long create(PcsSkuQualifyVO vo);

    /**
     * 更新SKU资质审批
     * @param vo
     * @return
     */
    Boolean update(PcsSkuQualifyVO vo);

    /**
     * 根据ID查找SKU资质审批
     * @param id
     * @return
     */
    PcsSkuQualifyVO findById(Long id);

    /**
     * 根据skuCode查找SKU资质审批
     * @param skuCode
     * @return
     */
    PcsSkuQualifyVO findBySkuCode(String skuCode);
    
    /**
     * 根据相应条件查找SKU资质审批
     * @param cond
     * @return
     */
    List<PcsSkuQualifyVO> findByCond(PcsSkuQualifyCond cond);

    /**
     * 根据条件查找SKU资质审批
     * @param cond
     * @return
     */
    List<PcsSkuQualifyVO> findByCriteria(PcsSkuQualifyCond cond);

    /**
     * 根据id集合查找SKU资质审批
     * @param ids
     * @return
     */
    List<PcsSkuQualifyVO> findByIds(List<Long> ids);

    /**
     * 审核SKU资质
     * @param id
     * @param isPass
     * @return
     */
    Boolean auditSkuQualify(Long userId, long id, Boolean isPass, Integer type);
    Boolean auditSkuQualify(ApprovalRecordVO vo, Boolean isPass,Integer importedType);
    Boolean auditSkuQualify(Long id, Boolean isPass, Integer type);
    
    long countByCond(PcsSkuQualifyCond cond);

    // 创建sku资质审批记录
	boolean createApprovalRecord(ApprovalRecordVO vo);
	
	List<ApprovalRecordVO> findApprovalRecordsByCond(ApprovalRecordCond cond);


    // 获取当前资质审批下的文件数量
    long getFileCountByCond(PcsSkuQualifyCond cond);
}
