package com.thebeastshop.pegasus.merchandise.enums;

import com.thebeastshop.common.enums.CodeEnum;

public enum SupplierKindEnum implements CodeEnum<Integer> {

    NORMAL(1, "普通"),
    FLOWER(2, "鲜花");

    private Integer code;
    private String name;

    SupplierKindEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }
}
