package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.util.List;

public class ImgProcessVO implements Serializable {
    private Integer productId;
    private String productCode;
    private Integer sourceWidth;
    private Integer sourceHeight;
    private String sourceUrl;
    private Integer seconds;
    private List<String> firstUrlList;
    private String firstBeforeUrl;
    private String firstAfterUrl;
    private String beforeWatermarkUrl0;
    private String beforeWatermarkUrl;
    private String afterWatermarkUrl;
    private String secondCategoryIds;
    private Integer x;
    private Integer y;
    private Integer xWidth;
    private Integer yHeight;
    private String bu;
    private String imgSource;

    private String groupName;

    private String lastError;

    private Integer isPng;

    private boolean hasPng;

    private Integer isSame;

    public Integer getProductId() {
        return productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Integer getSourceWidth() {
        return sourceWidth;
    }

    public void setSourceWidth(Integer sourceWidth) {
        this.sourceWidth = sourceWidth;
    }

    public Integer getSourceHeight() {
        return sourceHeight;
    }

    public void setSourceHeight(Integer sourceHeight) {
        this.sourceHeight = sourceHeight;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public Integer getSeconds() {
        return seconds;
    }

    public void setSeconds(Integer seconds) {
        this.seconds = seconds;
    }


    public String getFirstBeforeUrl() {
        return firstBeforeUrl;
    }

    public void setFirstBeforeUrl(String firstBeforeUrl) {
        this.firstBeforeUrl = firstBeforeUrl;
    }

    public String getFirstAfterUrl() {
        return firstAfterUrl;
    }

    public void setFirstAfterUrl(String firstAfterUrl) {
        this.firstAfterUrl = firstAfterUrl;
    }



    public String getBeforeWatermarkUrl() {
        return beforeWatermarkUrl;
    }

    public void setBeforeWatermarkUrl(String beforeWatermarkUrl) {
        this.beforeWatermarkUrl = beforeWatermarkUrl;
    }

    public String getBeforeWatermarkUrl0() {
        return beforeWatermarkUrl0;
    }

    public void setBeforeWatermarkUrl0(String beforeWatermarkUrl0) {
        this.beforeWatermarkUrl0 = beforeWatermarkUrl0;
    }


    public String getAfterWatermarkUrl() {
        return afterWatermarkUrl;
    }

    public void setAfterWatermarkUrl(String afterWatermarkUrl) {
        this.afterWatermarkUrl = afterWatermarkUrl;
    }


    public String getSecondCategoryIds() {
        if (secondCategoryIds == null){
            return "";
        }
        return secondCategoryIds;
    }

    public void setSecondCategoryId(String secondCategoryId) {
        this.secondCategoryIds = secondCategoryId;
    }

    public Integer getX() {
        return x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public Integer getxWidth() {
        return xWidth;
    }

    public void setxWidth(Integer xWidth) {
        this.xWidth = xWidth;
    }

    public Integer getyHeight() {
        return yHeight;
    }

    public void setyHeight(Integer yHeight) {
        this.yHeight = yHeight;
    }

    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }

    public String getImgSource() {
        return imgSource;
    }

    public void setImgSource(String imgSource) {
        this.imgSource = imgSource;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getLastError() {
        return lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    public Integer getIsPng() {
        return isPng;
    }

    public void setIsPng(Integer isPng) {
        this.isPng = isPng;
    }

    public boolean isHasPng() {
        return hasPng;
    }

    public void setHasPng(boolean hasPng) {
        this.hasPng = hasPng;
    }

    public Integer getIsSame() {
        return isSame;
    }

    public void setIsSame(Integer isSame) {
        this.isSame = isSame;
    }


    public List<String> getFirstUrlList() {
        return firstUrlList;
    }

    public void setFirstUrlList(List<String> firstUrlList) {
        this.firstUrlList = firstUrlList;
    }

    public boolean hasSecondCategoryId3077(){
        if (secondCategoryIds == null){
            return false;
        }
        if (secondCategoryIds.length() == 0){
            return false;
        }
        if (secondCategoryIds.contains("|3077|")){
            return true;
        }
        return false;
    }

    public boolean hasSecondCategoryId119(){
        if (secondCategoryIds == null){
            return false;
        }
        if (secondCategoryIds.length() == 0){
            return false;
        }
        if (secondCategoryIds.contains("|119|")){
            return true;
        }
        if (secondCategoryIds.contains("|178|")){
            return true;
        }
        return false;
    }

    public boolean hasSecondCategoryId2048X(){
        if (secondCategoryIds == null){
            return false;
        }
        if (secondCategoryIds.length() == 0){
            return false;
        }
        if (secondCategoryIds.contains("|190|")){
            return true;
        }
        if (secondCategoryIds.contains("|341|")){
            return true;
        }
        if (secondCategoryIds.contains("|2049|")){
            return true;
        }
        if (secondCategoryIds.contains("|2050|")){
            return true;
        }
        if (secondCategoryIds.contains("|2051|")){
            return true;
        }
        if (secondCategoryIds.contains("|2052|")){
            return true;
        }
        if (secondCategoryIds.contains("|2053|")){
            return true;
        }
        return false;
    }
    public String getImgType() {
        if (sourceWidth == null || sourceHeight == null){
            return "";
        }
        if (xWidth == null || yHeight == null){
            return "";
        }
        int xDiff = sourceWidth.intValue() - xWidth.intValue();
        int yDiff = sourceHeight.intValue() - yHeight.intValue();
        if (xDiff <= 1 && yDiff <= 1){
            return "原图";
        }
        if (xWidth.equals(yHeight)){
            return "竖图";
        }
        if (xWidth.intValue() > yHeight.intValue()){
            return "横图";
        }else{
            return "竖图";
        }
    }
    public boolean hasNakedBeast(){
        if(bu == null){
            return false;
        }
        if (bu.equals("Naked Beast")){
            return true;
        }
        if (bu.equals("Naked Beast (UW)")){
            return true;
        }
        return false;
    }
}
