/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.validation;

import com.thebeastshop.common.exception.BaseErrorCode;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.pegasus.merchandise.exception.DynmDetailsException;
import com.thebeastshop.pegasus.merchandise.exception.DynmDetailsExceptionCode;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynmDetailsValidation {
    private static final Logger log = LoggerFactory.getLogger(DynmDetailsValidation.class);

    private DynmDetailsValidation() {
    }

    public static void assertNotNull(Object object, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (object == null) {
            DynmDetailsValidation.throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertNotNull(Object object, String msg) {
        if (object == null) {
            DynmDetailsValidation.throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertNotEmpty(Collection collection, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            DynmDetailsValidation.throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertNotEmpty(Collection collection, String msg) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            DynmDetailsValidation.throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertNotEmpty(CharSequence str, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (EmptyUtil.isEmpty((Object)str)) {
            DynmDetailsValidation.throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertNotEmpty(String str, String msg) {
        if (EmptyUtil.isEmpty((String)str)) {
            DynmDetailsValidation.throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertNotEmpty(Map map, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (MapUtils.isEmpty((Map)map)) {
            DynmDetailsValidation.throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertNotEmpty(Map map, String msg) {
        if (MapUtils.isEmpty((Map)map)) {
            DynmDetailsValidation.throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertTrue(boolean condition, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (!condition) {
            DynmDetailsValidation.throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertTrue(boolean condition, String msg) {
        if (!condition) {
            DynmDetailsValidation.throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertTrue(boolean condition, DynmDetailsExceptionCode exceptionCode) {
        DynmDetailsValidation.assertTrue(condition, exceptionCode, null);
    }

    public static void rejectIf(Boolean condition, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (condition.booleanValue()) {
            DynmDetailsValidation.throwValidationException(exceptionCode, msg);
        }
    }

    public static void rejectIf(Boolean condition, DynmDetailsExceptionCode exceptionCode) {
        DynmDetailsValidation.rejectIf(condition, exceptionCode, null);
    }

    public static void rejectIf(Boolean condition, String msg) {
        if (condition.booleanValue()) {
            DynmDetailsValidation.throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void paramNotNull(Object obj, String msg) {
        if (obj == null) {
            DynmDetailsValidation.throwParamException(DynmDetailsExceptionCode.NULL_PARAM, msg);
        }
    }

    public static void paramNotEmpty(Collection collection, String msg) {
        if (EmptyUtil.isEmpty((Object)collection)) {
            DynmDetailsValidation.throwParamException(DynmDetailsExceptionCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramNotEmpty(CharSequence str, String msg) {
        if (EmptyUtil.isEmpty((Object)str)) {
            DynmDetailsValidation.throwParamException(DynmDetailsExceptionCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramNotEmpty(Map map, String msg) {
        if (EmptyUtil.isEmpty((Map)map)) {
            DynmDetailsValidation.throwParamException(DynmDetailsExceptionCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramMust(Boolean condition, String msg) {
        if (!condition.booleanValue()) {
            DynmDetailsValidation.throwParamException(DynmDetailsExceptionCode.ILLEGAL_PARAM, msg);
        }
    }

    private static StackTraceElement getStrackElement(int index) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[index];
        return stackTraceElement;
    }

    private static void throwValidationException(BaseErrorCode errorCode, String msg) {
        DynmDetailsValidation.throwValidationException("\u6570\u636e\u6821\u9a8c\u9519\u8bef", errorCode, msg, 5);
    }

    private static void throwParamException(BaseErrorCode errorCode, String msg) {
        DynmDetailsValidation.throwValidationException("\u53c2\u6570\u6821\u9a8c\u9519\u8bef", errorCode, msg, 5);
    }

    private static void throwValidationException(String type, BaseErrorCode errorCode, String msg, int index) {
        StackTraceElement stackTraceElement = DynmDetailsValidation.getStrackElement(index);
        String class_method = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
        String text = "[" + type + ": " + errorCode.getErrorCode() + "] \u8c03\u7528\u65b9\u6cd5[" + class_method + "]\u65f6" + errorCode.getMessage() + ": " + msg;
        log.error(text);
        throw new DynmDetailsException((DynmDetailsExceptionCode)errorCode, msg);
    }
}

