package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * sku类型枚举
 * @author Gary
 *
 */
public enum PcsSkuPurchaseStatusEnum {

	COMMON(1, "普通"),
	CEASE_WHEN_SOLD_OUT(0, "停止采购(售完即止)"),
	CEASE_WHEN_CLEARANCE(-1, "停止采购(清仓)"),
	CEASE_WHEN_QUALITY_PROBLEM(-2, "停止采购(品质问题)");

	public final Integer status;
	public final String desc;

	public static final List<PcsSkuPurchaseStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PcsSkuPurchaseStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	public final static List<Map<String, Object>> listMapEnum() {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		for (PcsSkuPurchaseStatusEnum skuTypeEnum : ALL) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("value", skuTypeEnum.status);
			map.put("name", skuTypeEnum.desc);
			list.add(map);
		}
		return list;
	}

	 // 普通方法
    public static String getDesc(Integer status) {
		  if (status == null) {
        return  "";
			}
			for (PcsSkuPurchaseStatusEnum c : ALL) {
					if (c.getStatus().equals(status)) {
							return c.desc;
					}
			}
			return null;
    }

	public final static Integer getStatusByDesc(String desc) {
		if (desc == null) {
			return null;
		}
		for (PcsSkuPurchaseStatusEnum skuPurchaseStatusEnum : PcsSkuPurchaseStatusEnum.values()) {
			if (desc.equals(skuPurchaseStatusEnum.desc)) {
				return skuPurchaseStatusEnum.status;
			}
		}
		return null;
	}

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}
}
