package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * SKU商品类型
 * @author Gary
 *
 */
public enum PcsSkuProductTypeEnum {

	GENERAL((short)1, "普通商品"),
	GIFT((short) 2, "赠品"),
	SAMPLE((short) 3, "试用装"),
	EXHIBITS((short) 4, "陈列品");

	public final Short type;
	public final String desc;

	public static final List<PcsSkuProductTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PcsSkuProductTypeEnum(final Short type, final String desc) {
		this.type = type;
		this.desc = desc;
	}


	public final static List<Map<String, Object>> listMapEnum() {
		List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
		for (PcsSkuProductTypeEnum pcsSkuProductTypeEnum : ALL) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("type", pcsSkuProductTypeEnum.type);
			map.put("desc", pcsSkuProductTypeEnum.desc);
			listMap.add(map);
		}
		return listMap;
	}
	  // 普通方法
	 public static String getDesc(Short status) {
		for (PcsSkuProductTypeEnum c : ALL) {
					if (c.type == status) {
							return c.desc;
					}
		 }
		return null;
	}

	public final static Short getTypeByDesc(String companyDesc) {
		Short statusVal = null;
		for (PcsSkuProductTypeEnum pcsSkuProductTypeEnum : values()) {
			if (pcsSkuProductTypeEnum.desc.equals(companyDesc)) {
				statusVal = pcsSkuProductTypeEnum.type;
				break;
			}
		}
		return statusVal;
	}

	public Short getType() {
		return type;
	}

	public String getDesc() {
		return desc;
	}
}
