package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;
import java.util.Map;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCustomsRecordInfoCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomsRecordInfoVO;

import page.Pagination;

/**
 * 关务备案信息
 * @version V1.0
 * @Description todo
 * @author xh
 * @date 2019年1月16日
 */
public interface McPcsSkuCustomsRecordInfoService {
	
	/**
	 * 根据SKUCODE和所属海关判断是否存在相同数据
	 * @param vo
	 * @return
	 */
	boolean findCustomsInfoNumByCodeAndType(PcsSkuCustomsRecordInfoVO vo);
	
	/**
	 * 根据SKUCODE和所属海关判断是否备案完成
	 */
	boolean isRecordCompletionByCodeAndType(PcsSkuCustomsRecordInfoVO vo);
	
	/**
	 * 根据SKUCODE和所属海关判断是否存在商品货号
	 * @param vo
	 * @return
	 */
	boolean isExistSkuItemCode(PcsSkuCustomsRecordInfoVO vo);
	
	/**
	 * 批量导入海关备案数据
	 * @param list
	 * @return
	 */
	boolean batchInsertCustomsRecordInfo(List<PcsSkuCustomsRecordInfoVO> list);
	
	/**
	 * 批量更新海关备案数据
	 */
	boolean batchUpdateCustomsRecordInfo(List<PcsSkuCustomsRecordInfoVO> list);
	
	/**
	 * 根据SKU查询关务信息
	 * @param skuCode
	 * @return
	 */
	List<PcsSkuCustomsRecordInfoVO> findCustomsRecordInfoByCode(String skuCode);

	/**
	 * 根据SKU和所属海关查询关务信息
	 * @param skuCode
	 * @param cusType
	 * @return
	 */
	PcsSkuCustomsRecordInfoVO findCustomsRecordInfoByCodeAndType(String skuCode,Integer cusType);

	Map<String, PcsSkuCustomsRecordInfoVO> findCustomsRecordInfoBySkucodes(List<String> skuCodeList);
	
	/**
	 * 根据条件查询关务信息
	 * @param cond
	 * @return
	 */
	List<PcsSkuCustomsRecordInfoVO> findCustomsRecordInfoByCond(PcsSkuCustomsRecordInfoCond cond);
	
	/**
	 * 根据数组参数查找关务信息
	 *
	 * @param code
	 * @return
	 */
	List<PcsSkuCustomsRecordInfoVO> findByCodes(String... code);
	
	/**
     * 根据条件查找备案数据基于分页
     *
     * @param cond
     * @return
     */
	Pagination<PcsSkuCustomsRecordInfoVO> findCustomsRecordInfoVOByCondPage(PcsSkuCustomsRecordInfoCond cond);
	
	/**
	 * 统计列表页各种状态
	 * @param cond
	 * @return
	 */
	Map<String,Integer> countForList(PcsSkuCustomsRecordInfoCond cond);
	
	/**
	 * 更新关务信息
	 * @param vo
	 * @return
	 */
	ServiceResp<PcsSkuCustomsRecordInfoVO> updateSkuCustomsRecordInfo(PcsSkuCustomsRecordInfoVO vo);
	
	/**
	 * 根据条件更新关务信息
	 * @param vo
	 * @return
	 */
	boolean updateSkuCustomsRecordTypeByCondVO(PcsSkuCustomsRecordInfoVO vo);
}
