package com.thebeastshop.pegasus.merchandise.exception;

/**
 * 权益异常类
 * @Class Name InterestException
 * @Author Xiang.Gao
 * @Create In 2017-3-1
 */
public class InterestException extends RuntimeException{

	 /**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;
	
	private String errorCode;

    public InterestException(String errorCode) {
        super();
        this.errorCode = errorCode;
    }
    
    public InterestException(InterestExceptionEnum errorEnum){
    	super(errorEnum.getErrMsg());
    	this.errorCode = errorEnum.getErrCode();
    }

    public InterestException(String errorCode, String msg) {
        super(msg);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}
