package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Created by QTJ on 2017/6/15.
 */
public enum CopywriterValidStatusEnum {

    PENDING_EFFECT(0,"待生效"),

    ALREADY_IN_FORCE(1,"已生效"),

    Expired(2,"已失效");

    public final Integer status;
    public final String desc;

    public static final List<CopywriterValidStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    private CopywriterValidStatusEnum(final Integer status, final String desc) {
        this.status = status;
        this.desc = desc;
    }

    // 普通方法
    public static String getDesc(int status) {
        for (CopywriterValidStatusEnum c : CopywriterValidStatusEnum .values()) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
