package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Gary
 * @createTime 2019/08/05
 */
@ExcelSheet("关税税率")
@ExcelTemplate
public class PcsSkuCategoryConfigVO implements Serializable {

    private static final long serialVersionUID = -2756402930351441470L;
    private Integer categoryId;
    @ExcelColumn(name = "关税税率")
    private BigDecimal tariff;
    @ExcelColumn(name = "三级类目")
    @NotNull
    private String categoryName;
    private String categoryCode;

    public Integer getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    public BigDecimal getTariff() {
        return tariff;
    }

    public void setTariff(BigDecimal tariff) {
        this.tariff = tariff;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }
}
