package com.thebeastshop.pegasus.merchandise.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import com.thebeastshop.pegasus.util.comm.DateUtil;

public class DateUtils {
	
	public static final String  DEFAULT_DATE_FORMAT = "yyyy-MM-dd";

	public static String workDays(String strStartDate, String strEndDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        Calendar cl1 = Calendar.getInstance();
        Calendar cl2 = Calendar.getInstance();

        try {
            cl1.setTime(df.parse(strStartDate));
            cl2.setTime(df.parse(strEndDate));

        } catch (ParseException e) {
            System.out.println("日期格式非法");
            e.printStackTrace();
        }
        
        Long time =  cl2.getTimeInMillis() - cl1.getTimeInMillis();
        
        int count = 0;
        while (cl1.compareTo(cl2) <= 0) {
            if (cl1.get(Calendar.DAY_OF_WEEK) != 7 && cl1.get(Calendar.DAY_OF_WEEK) != 1)
                count++;
            cl1.add(Calendar.DAY_OF_MONTH, 1);
        }
        
        
        int nDays =  nDaysBetweenTwoDate(strStartDate, strEndDate);
        int minute = (int) (time/(1000 * 60));
        
        int differenceHours = (minute - 60 * 24 * nDays)/60;
        
        return count - 1 + "天" + Math.abs(differenceHours) + "小时";
        

    }
	// 计算两个日期相隔的天数
	public static int nDaysBetweenTwoDate(String firstString, String secondString) {
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date firstDate = null;
		Date secondDate = null;
		try {
			firstDate = df.parse(firstString);
			secondDate = df.parse(secondString);
		} catch (Exception e) {
			// 日期型字符串格式错误
			System.out.println("日期型字符串格式错误");
		}
		int nDay = (int) ((secondDate.getTime() - firstDate.getTime()) / (24 * 60 * 60 * 1000));
		return nDay;
	}
	
	
	/**
	 * 获取当前date
	 * @Methods Name getCurrentDate
	 * @Create In 2017-3-9 By Xiang.Gao
	 * @return Date
	 */
	public static Date getCurrentDate() {
		return DateUtil.getNow();
	}
	
	
	/**
	 * 获取当前date(仅精确到日期)
	 * @Methods Name getCurrentDateYMD
	 * @Create In 2017-3-9 By Xiang.Gao
	 * @return Date
	 */
	public static Date getCurrentDateYMD(){
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd"); 
		String date = df.format(new Date());
		return DateUtil.parse(date, "yyyy-MM-dd");
	}
	
}
