/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.util.DateUtils;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Roy.Chen
 * @version $Id: OpProductVO.java, v 0.1 2015-08-14 17:13
 */
@ExcelTemplate
public class OpProductVO implements Serializable {
    /**
     * ID
     */
    private Long id;

    private Boolean combined = false;

    /**
     * 组合商品子SKU列表组
     */
    private Map<String, OpSubSkuGroupVO> subSkuGroups;

    private String category1Name;

    private Long category1Id;

    private String category2Name;

    private Long category2Id;

    private List<OpCategoryVO> frontCategoryList;
    
    private List<OpWatermarkVO> watermarkLis;
    
    private List<OpTagVO> tags;

    private Date firstOnSaleTime;

    /**
     * 属性列表
     */
    private List<OpAttributeVO> attributeList;

    /**
     * 产品编码
     */
    @ExcelColumn(name="PRODUCT_CODE")
    @NotNull
    private String code;
    /**
     * 列表价
     */
    private BigDecimal listPrice;

    /**
     * sku售价
     */
    private String skuSalesPrice;
    /**
     * sku售价
     */
    private String newSalesPrice;

    /**
     * 是否支持VIP折扣，1是0否
     */
    private Integer allowVipDiscount;
    /**
     * 是否支持代写卡片，0否1是
     */
    private Integer allowNoteCard;
    /**
     * 备货天数，默认0
     */
    private Integer prepareDays;
    /**
     * 可选择配送日期天数，0:尽快（不可选），n:n天内（默认n=7）
     */
    private Integer selectDeliveryDays;
    /**
     * 图片（列表）
     */
    private String picList;
    /**
     * 图片（详情）
     */
    private String picDetail;
    /**
     * Database Column Remarks:
     *   多张详情图片
     */
    private String picDetailMul;

    /**
     * 图片（缩略）
     */
    private String picThumb;
    
    /**
     * 视频
     */
    private String video;
    
    /**
     * 视频封面
     */
    private String videoCover;

    /**
     * 产品名
     */
    @ExcelColumn(name="PROD_NAME")
    private String name;
    /**
     * 产品中文名
     */
    private String nameCn;
    /**
     * SKU分类描述
     */
    private String skuCategoryDesc;
    /**
     * 快递类型，1店送2联邦3顺丰
     */
    private Integer expressType;

    private List<String> skuCodes;
    private List<OpSpvVO> spvList;

    private Date saleStartDate;

    /**
     * 是否预售
     */
    private Boolean isPresale;

    private Integer sort1;

    private Integer sort2;

    private Integer seq;
    
	private String description;

    private Integer prodStatus;

    private Integer temProdStatus;

    private Integer createUserId;

    private String nickName;
    
    private Date lastAuditTime;
    
    private Date lastSubmitTime;
    
    private String lastApproverName;
    
    private String lastAuditRemark;
    
    private Integer lastApprover;

    private Boolean isLuckybag;

    /**
     * 月送鲜花
     */
    private Integer isMonthSend;

    /**
     * 生日折扣
     */
    private Integer allowBdDiscount;

    /**
     * 是否参加活动
     */
    private Integer allowCampaign;

    /**
     * 商品贸易类型： 1.海淘 0.非海淘
     */
    private Integer tradeType;

    /**
     * 展示在商详页
     */
    private Boolean displayInProdDetail;

    /**
     * 展示在组合商品专区
     */
    private Boolean displayInCombinedArea;

    private Integer brandId;

    private Integer approveUserId;

    private String createMan;
    private Date createTime;
    private String approveName;
    private String bu;
    private String giftRecommendImg;
    private String giftRecommendReason;
    
    public String getHasBeenWaiting() {
    	String hasBeenWaiting = "";
    	if(EmptyUtil.isEmpty(lastSubmitTime)) {
    		hasBeenWaiting =  "0天0小时";
    	} else {
    		hasBeenWaiting = DateUtils.workDays(DateUtil.format(lastSubmitTime, "yyyy-MM-dd HH:mm:ss"), 
    				DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
    	}
		return hasBeenWaiting;
	}

    public Integer getIsMonthSend() {
		return isMonthSend;
	}

	public void setIsMonthSend(Integer isMonthSend) {
		this.isMonthSend = isMonthSend;
	}

	public Date getLastAuditTime() {
		return lastAuditTime;
	}

	public void setLastAuditTime(Date lastAuditTime) {
		this.lastAuditTime = lastAuditTime;
	}

	public Date getLastSubmitTime() {
		return lastSubmitTime;
	}

	public void setLastSubmitTime(Date lastSubmitTime) {
		this.lastSubmitTime = lastSubmitTime;
	}

	public String getLastApproverName() {
		return lastApproverName;
	}

	public void setLastApproverName(String lastApproverName) {
		this.lastApproverName = lastApproverName;
	}

	public String getLastAuditRemark() {
		return lastAuditRemark;
	}

	public void setLastAuditRemark(String lastAuditRemark) {
		this.lastAuditRemark = lastAuditRemark;
	}

	public Integer getLastApprover() {
		return lastApprover;
	}

	public void setLastApprover(Integer lastApprover) {
		this.lastApprover = lastApprover;
	}

	public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public Map<String, OpSubSkuGroupVO> getSubSkuGroups() {
        return subSkuGroups;
    }

    public void setSubSkuGroups(Map<String, OpSubSkuGroupVO> subSkuGroups) {
        this.subSkuGroups = subSkuGroups;
    }

    public String getCategory1Name() {
        return category1Name;
    }

    public void setCategory1Name(String category1Name) {
        this.category1Name = category1Name;
    }

    public Long getCategory1Id() {
        return category1Id;
    }

    public void setCategory1Id(Long category1Id) {
        this.category1Id = category1Id;
    }

    public String getCategory2Name() {
        return category2Name;
    }

    public void setCategory2Name(String category2Name) {
        this.category2Name = category2Name;
    }

    public Long getCategory2Id() {
        return category2Id;
    }

    public void setCategory2Id(Long category2Id) {
        this.category2Id = category2Id;
    }

    public List<OpCategoryVO> getFrontCategoryList() {
        return frontCategoryList;
    }

    public void setFrontCategoryList(List<OpCategoryVO> frontCategoryList) {
        this.frontCategoryList = frontCategoryList;
    }

	public List<OpWatermarkVO> getWatermarkLis() {
		return watermarkLis;
	}

	public void setWatermarkLis(List<OpWatermarkVO> watermarkLis) {
		this.watermarkLis = watermarkLis;
	}
	
	public List<OpTagVO> getTags() {
		return tags;
	}

	public void setTags(List<OpTagVO> tags) {
		this.tags = tags;
	}

	public Date getFirstOnSaleTime() {
        return firstOnSaleTime;
    }

    public void setFirstOnSaleTime(Date firstOnSaleTime) {
        this.firstOnSaleTime = firstOnSaleTime;
    }

    public List<OpAttributeVO> getAttributeList() {
        return attributeList;
    }

    public void setAttributeList(List<OpAttributeVO> attributeList) {
        this.attributeList = attributeList;
    }

    public Integer getSort1() {
        return sort1;
    }

    public void setSort1(Integer sort1) {
        this.sort1 = sort1;
    }

    public Integer getSort2() {
        return sort2;
    }

    public void setSort2(Integer sort2) {
        this.sort2 = sort2;
    }

    public Integer getSeq() {
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    private List<OpProdCanDeliveryVO> prodCanDeliveryVOs;

    public List<OpProdCanDeliveryVO> getProdCanDeliveryVOs() {
        return prodCanDeliveryVOs;
    }

    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public void setProdCanDeliveryVOs(List<OpProdCanDeliveryVO> prodCanDeliveryVOs) {
        this.prodCanDeliveryVOs = prodCanDeliveryVOs;
    }

    public String getSkuCategoryDesc() {
        return skuCategoryDesc;
    }

    public void setSkuCategoryDesc(String skuCategoryDesc) {
        this.skuCategoryDesc = skuCategoryDesc;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return listPrice;
    }

    public void setListPrice(BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public String getSkuSalesPrice() {
        return skuSalesPrice;
    }

    public void setSkuSalesPrice(String skuSalesPrice) {
        this.skuSalesPrice = skuSalesPrice;
    }

    public Integer getAllowVipDiscount() {
        return allowVipDiscount;
    }

    public void setAllowVipDiscount(Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return allowNoteCard;
    }

    public void setAllowNoteCard(Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }

    public Integer getPrepareDays() {
        return prepareDays;
    }

    public void setPrepareDays(Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return selectDeliveryDays;
    }

    public void setSelectDeliveryDays(Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

    public String getPicList() {
        return picList;
    }

    public void setPicList(String picList) {
        this.picList = picList;
    }

    public String getPicDetailMul() {
        return picDetailMul;
    }

    public void setPicDetailMul(String picDetailMul) {
        this.picDetailMul = picDetailMul;
    }

    public String getPicDetail() {
        return picDetail;
    }

    public void setPicDetail(String picDetail) {
        this.picDetail = picDetail;
    }

    public String getPicThumb() {
        return picThumb;
    }

    public void setPicThumb(String picThumb) {
        this.picThumb = picThumb;
    }

    public List<OpSpvVO> getSpvList() {
        return spvList;
    }

    public void setSpvList(List<OpSpvVO> spvList) {
        this.spvList = spvList;
    }

    public Date getSaleStartDate() {
        return saleStartDate;
    }

    public void setSaleStartDate(Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public Boolean getPresale() {
        return isPresale;
    }

    public void setPresale(Boolean presale) {
        isPresale = presale;
    }

    public List<String> getPicDetails(){
        if (StringUtils.isBlank(picDetail)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(picDetail.split(","));
    }

    public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

    public Integer getProdStatus() {
        return prodStatus;
    }

    public void setProdStatus(Integer prodStatus) {
        this.prodStatus = prodStatus;
    }

    public Integer getTemProdStatus() {
        return temProdStatus;
    }

    public void setTemProdStatus(Integer temProdStatus) {
        this.temProdStatus = temProdStatus;
    }

    public Integer getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Integer createUserId) {
        this.createUserId = createUserId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Boolean getIsLuckybag() {
        return isLuckybag;
    }

    public void setIsLuckybag(Boolean isLuckybag) {
        this.isLuckybag = isLuckybag;
    }

    public Integer getAllowBdDiscount() {
        return allowBdDiscount;
    }

    public void setAllowBdDiscount(Integer allowBdDiscount) {
        this.allowBdDiscount = allowBdDiscount;
    }

	public String getVideo() {
		return video;
	}

	public void setVideo(String video) {
		this.video = video;
	}

	public String getVideoCover() {
		return videoCover;
	}

	public void setVideoCover(String videoCover) {
		this.videoCover = videoCover;
	}

    public Integer getTradeType() {
        return tradeType;
    }

    public void setTradeType(Integer tradeType) {
        this.tradeType = tradeType;
    }

    public Boolean getDisplayInProdDetail() {
        return displayInProdDetail;
    }

    public void setDisplayInProdDetail(Boolean displayInProdDetail) {
        this.displayInProdDetail = displayInProdDetail;
    }

    public Boolean getDisplayInCombinedArea() {
        return displayInCombinedArea;
    }

    public void setDisplayInCombinedArea(Boolean displayInCombinedArea) {
        this.displayInCombinedArea = displayInCombinedArea;
    }

    public Integer getAllowCampaign() {
        return allowCampaign;
    }

    public void setAllowCampaign(Integer allowCampaign) {
        this.allowCampaign = allowCampaign;
    }

    public Integer getBrandId() {
        return brandId;
    }

    public void setBrandId(Integer brandId) {
        this.brandId = brandId;
    }

    public Integer getApproveUserId() {
        return approveUserId;
    }

    public void setApproveUserId(Integer approveUserId) {
        this.approveUserId = approveUserId;
    }

    public String getCreateMan() {
        return createMan;
    }

    public void setCreateMan(String createMan) {
        this.createMan = createMan;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getApproveName() {
        return approveName;
    }

    public void setApproveName(String approveName) {
        this.approveName = approveName;
    }

    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }

    public String getGiftRecommendImg() {
        return giftRecommendImg;
    }

    public void setGiftRecommendImg(String giftRecommendImg) {
        this.giftRecommendImg = giftRecommendImg;
    }

    public String getGiftRecommendReason() {
        return giftRecommendReason;
    }

    public void setGiftRecommendReason(String giftRecommendReason) {
        this.giftRecommendReason = giftRecommendReason;
    }

    public String getNewSalesPrice() {
        return newSalesPrice;
    }

    public void setNewSalesPrice(String newSalesPrice) {
        this.newSalesPrice = newSalesPrice;
    }
}
