package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 商品属性状态
 * @author Gary
 *
 */
public enum OpProdDynmDetailsAuditLogStatusEnum {

	AUDIT_NIT("00", "待审查"),
	AUDIT_PASS("01", "审查通过"),
	AUDIT_REJECT("02", "审查不通过"),
	;

	public final String code;
	public final String value;

	public static final List<OpProdDynmDetailsAuditLogStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private OpProdDynmDetailsAuditLogStatusEnum(final String code, final String value) {
		this.code = code;
		this.value = value;
	}

	 // 普通方法
    public static String getValue(String code) {
        for (OpProdDynmDetailsAuditLogStatusEnum c : OpProdDynmDetailsAuditLogStatusEnum.values()) {
            if (c.getCode() == code) {
                return c.value;
            }
        }
        return null;
    }


	public String getValue() {
		return value;
	}

	public String getCode() {
		return code;
	}

	public static List<OpProdDynmDetailsAuditLogStatusEnum> getALL() {
		return ALL;
	}
}
