package com.thebeastshop.pegasus.merchandise.cond;

import com.thebeastshop.pegasus.merchandise.enums.SoldOutProdDisplayEnum;
import com.thebeastshop.pegasus.merchandise.vo.PsCategoryCampaignVO;

import java.io.Serializable;
import java.util.List;

/**
 * @author Lk
 * @since 2016-08-29
 */
public class ProdSearchCond implements Serializable {
    /**
     * 渠道号
     */
    private String channelCode;
    /**
     * 类目Id列表
     */
    private List<String> categoryCodes;
    /**
     * 是否新上架(0:不用上架 1：上架)
     */
    private Boolean isNew;
    /**
     * 新上架时间范围
     */
    private DateRange dateRange;
    /**
     * 【分页】从第几个开始
     */
    private Integer from;
    /**
     * 【分页】每次查询几个
     */
    private Integer size;
    /**
     * create_time 按上架时间
     * price 按价格
     * sales 按销量
     * synthesis 综合
     */
    private String sortField;
    /**
     * ASC 升序
     * DESC 降序
     */
    private String sortOrder;
    /**
     * 关键字模糊查询
     */
    private String Keywords;
    /**
     * 是否是海淘商品(1：是 0：否)C
     */
    private Boolean isCrossBorder;
    /**
     * 水印标签
     */
    private String psTags;
    /**
     * 标签
     */
    private String labels;
    /**
     * 品牌
     */
    private String brandId;

    private List<String> brandIds;

    private List<String> labelIds;

    /**
     * 1 品牌聚合 2 标签聚合 3 类目聚合
     */
    private Integer aggs;
    //SKU属性ID
    private Long skuAttrId;
    //SKU属性ID
    private Long skuAttrValueId;
    //折扣活动类目ID
    private List<Long> campCateIds;
    //折扣活动类目
    private List<PsCategoryCampaignVO> PsCategoryCampaignList;
    //本地库存
    private Boolean isLocalStock;
    //组合
    private Boolean isCombined;
    //新人专享
    private Boolean isNewMember;
    //生日到店礼
    private Boolean isBirthday;

    /**
     * BU
     */
    private String bu;

    private Boolean isAll;

    private List<String> prodCodes;
    //标签交集
    private List<Long> intersectionLabelIds;

    private SoldOutProdDisplayEnum soldOutProdDisplayEnum;;

    private TrackSearchDataCond trackSearchDataCond;

    private String pageName;
    //是否折扣
    private Boolean isDiscount;
    private List<Long> prodIds;

    /**
     * 选中品牌、标签、分类列表
     */
    private List<String> selectedcategoryCodes;
    private List<String> selectedBrandIds;
    private List<String> selectedLabelIds;

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public List<String> getCategoryCodes() {
        return categoryCodes;
    }

    public void setCategoryCodes(List<String> categoryCodes) {
        this.categoryCodes = categoryCodes;
    }

    public Boolean getIsNew() {
        return isNew;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public DateRange getDateRange() {
        return dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public Integer getFrom() {
        return from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getKeywords() {
        return Keywords;
    }

    public void setKeywords(String keywords) {
        Keywords = keywords;
    }

    public Boolean getIsCrossBorder() {
        return isCrossBorder;
    }

    public void setIsCrossBorder(Boolean isCrossBorder) {
        this.isCrossBorder = isCrossBorder;
    }

    public String getPsTags() {
        return psTags;
    }

    public void setPsTags(String psTags) {
        this.psTags = psTags;
    }

    public String getLabels() {
        return labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public List<String> getBrandIds() {
        return brandIds;
    }

    public void setBrandIds(List<String> brandIds) {
        this.brandIds = brandIds;
    }

    public List<String> getLabelIds() {
        return labelIds;
    }

    public void setLabelIds(List<String> labelIds) {
        this.labelIds = labelIds;
    }

    public Integer getAggs() {
        return aggs;
    }

    public void setAggs(Integer aggs) {
        this.aggs = aggs;
    }

    public Long getSkuAttrId() {
        return skuAttrId;
    }

    public void setSkuAttrId(Long skuAttrId) {
        this.skuAttrId = skuAttrId;
    }

    public Long getSkuAttrValueId() {
        return skuAttrValueId;
    }

    public void setSkuAttrValueId(Long skuAttrValueId) {
        this.skuAttrValueId = skuAttrValueId;
    }

    public List<Long> getCampCateIds() {
        return campCateIds;
    }

    public void setCampCateIds(List<Long> campCateIds) {
        this.campCateIds = campCateIds;
    }

    public List<PsCategoryCampaignVO> getPsCategoryCampaignList() {
        return PsCategoryCampaignList;
    }

    public void setPsCategoryCampaignList(List<PsCategoryCampaignVO> psCategoryCampaignList) {
        PsCategoryCampaignList = psCategoryCampaignList;
    }

    public TrackSearchDataCond getTrackSearchDataCond() {
        return trackSearchDataCond;
    }

    public void setTrackSearchDataCond(TrackSearchDataCond trackSearchDataCond) {
        this.trackSearchDataCond = trackSearchDataCond;
    }

    public Boolean getIsLocalStock() {
        return isLocalStock;
    }

    public void setIsLocalStock(Boolean isLocalStock) {
        this.isLocalStock = isLocalStock;
    }

    public Boolean getIsCombined() {
        return isCombined;
    }

    public void setIsCombined(Boolean isCombined) {
        this.isCombined = isCombined;
    }

    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }

    public Boolean getIsAll() {
        return isAll;
    }

    public void setIsAll(Boolean isAll) {
        this.isAll = isAll;
    }

    public List<String> getProdCodes() {
        return prodCodes;
    }

    public void setProdCodes(List<String> prodCodes) {
        this.prodCodes = prodCodes;
    }

    public SoldOutProdDisplayEnum getSoldOutProdDisplayEnum() {
        return soldOutProdDisplayEnum;
    }

    public void setSoldOutProdDisplayEnum(SoldOutProdDisplayEnum soldOutProdDisplayEnum) {
        this.soldOutProdDisplayEnum = soldOutProdDisplayEnum;
    }

    public Boolean getIsNewMember() {
        return isNewMember;
    }

    public void setIsNewMember(Boolean isNewMember) {
        this.isNewMember = isNewMember;
    }

    public Boolean getIsBirthday() {
        return isBirthday;
    }

    public void setIsBirthday(Boolean isBirthday) {
        this.isBirthday = isBirthday;
    }

    public String getPageName() {
        return pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public List<Long> getIntersectionLabelIds() {
        return intersectionLabelIds;
    }

    public void setIntersectionLabelIds(List<Long> intersectionLabelIds) {
        this.intersectionLabelIds = intersectionLabelIds;
    }

    public Boolean getIsDiscount() {
        return isDiscount;
    }

    public void setIsDiscount(Boolean isDiscount) {
        this.isDiscount = isDiscount;
    }

    public List<Long> getProdIds() {
        return prodIds;
    }

    public void setProdIds(List<Long> prodIds) {
        this.prodIds = prodIds;
    }

    public List<String> getSelectedcategoryCodes() {
        return selectedcategoryCodes;
    }

    public void setSelectedcategoryCodes(List<String> selectedcategoryCodes) {
        this.selectedcategoryCodes = selectedcategoryCodes;
    }

    public List<String> getSelectedBrandIds() {
        return selectedBrandIds;
    }

    public void setSelectedBrandIds(List<String> selectedBrandIds) {
        this.selectedBrandIds = selectedBrandIds;
    }

    public List<String> getSelectedLabelIds() {
        return selectedLabelIds;
    }

    public void setSelectedLabelIds(List<String> selectedLabelIds) {
        this.selectedLabelIds = selectedLabelIds;
    }

    @Override
    public String toString() {
        return "channelCode :" + channelCode + " keywords :" + Keywords + " pageName :"+pageName + " categoryCodes :" + categoryCodes + " brandIds :" + brandIds;
    }

}
