/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.pegasus.merchandise.cond.ActivityPageCond;
import com.thebeastshop.pegasus.merchandise.vo.ActivityPageRuleVO;
import com.thebeastshop.pegasus.merchandise.vo.ActivityPageVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdCreatorVO;
import com.thebeastshop.pegasus.merchandise.vo.RecommendVO;

import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:28
 */
public interface ActivityPageService{

    Long findByName(String pageName);

    Long getPageIdFromRedis(String pageName);

    List<ActivityPageVO> findActivityPageNmme();

    List<ProdCreatorVO> findActivityCreator();

    List<ActivityPageVO> findActivityPageNameHasSortPage();

    PageQueryResp<ActivityPageVO> listPage(ActivityPageCond cond);

    Boolean addActivityPageRule(ActivityPageRuleVO vo);

    Boolean insertOrUpdateActivityPage(List<RecommendVO> list);

    ActivityPageRuleVO findActivityPageById(Long id);

    Boolean deleteActivityPageById(Long id);

}
