/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.util.Date;

import com.thebeastshop.pegasus.merchandise.util.DateUtils;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

/**
 * @author Eric.Lou
 * @version $Id: PcsBrandVO.java, v 0.1 2015-07-30 10:51
 */
public class PcsBrandVO implements Serializable {

    // constructor
    public PcsBrandVO() {

    }

    // original
    private Long id;

    private String name;

    private String nameCn;

    private Date createTime;

    private Long countryId;

    private Integer fileId;

    private String description;

    private Integer isOwn;

    // self
    private String fileName;
    
    private Date trademarkStart;
    
    private Date trademarkEnd;
    
    private Integer brandStatus;
    
    private Integer optType;
    
    private Long creator;
    
    private Long lastModifier;
    
    private String creatorCN;
    
    private String lastModifierCN;
    
    private Integer authLetter;
    
    private boolean saveDraft;
    
    private Date lastAuditTime;
    
    private Date lastSubmitTime;
    
    private String lastApproverName;
    
    private String lastAuditRemark;
    
    private Integer lastApprover;

	private Long submitAuditUserId;
    
    
    public String getHasBeenWaiting() {
    	String hasBeenWaiting = "";
    	if(EmptyUtil.isEmpty(lastSubmitTime)) {
    		hasBeenWaiting =  "0天0小时";
    	} else {
    		hasBeenWaiting = DateUtils.workDays(DateUtil.format(lastSubmitTime, "yyyy-MM-dd HH:mm:ss"), 
    				DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
    	}
		return hasBeenWaiting;
	}

	
	public Integer getLastApprover() {
		return lastApprover;
	}

	public void setLastApprover(Integer lastApprover) {
		this.lastApprover = lastApprover;
	}

	public String getLastApproverName() {
		return lastApproverName;
	}

	public void setLastApproverName(String lastApproverName) {
		this.lastApproverName = lastApproverName;
	}

	public String getLastAuditRemark() {
		return lastAuditRemark;
	}

	public void setLastAuditRemark(String lastAuditRemark) {
		this.lastAuditRemark = lastAuditRemark;
	}

	public Date getLastAuditTime() {
		return lastAuditTime;
	}

	public void setLastAuditTime(Date lastAuditTime) {
		this.lastAuditTime = lastAuditTime;
	}

	public Date getLastSubmitTime() {
		return lastSubmitTime;
	}

	public void setLastSubmitTime(Date lastSubmitTime) {
		this.lastSubmitTime = lastSubmitTime;
	}

	public boolean isSaveDraft() {
		return saveDraft;
	}

	public void setSaveDraft(boolean saveDraft) {
		this.saveDraft = saveDraft;
	}

	public Integer getAuthLetter() {
		return authLetter;
	}

	public void setAuthLetter(Integer authLetter) {
		this.authLetter = authLetter;
	}

	public Long getCreator() {
		return creator;
	}

	public void setCreator(Long creator) {
		this.creator = creator;
	}

	public Long getLastModifier() {
		return lastModifier;
	}

	public void setLastModifier(Long lastModifier) {
		this.lastModifier = lastModifier;
	}

	public String getCreatorCN() {
		return creatorCN;
	}

	public void setCreatorCN(String creatorCN) {
		this.creatorCN = creatorCN;
	}

	public String getLastModifierCN() {
		return lastModifierCN;
	}

	public void setLastModifierCN(String lastModifierCN) {
		this.lastModifierCN = lastModifierCN;
	}

	public Integer getOptType() {
		return optType;
	}

	public void setOptType(Integer optType) {
		this.optType = optType;
	}

	public Date getTrademarkStart() {
		return trademarkStart;
	}

	public void setTrademarkStart(Date trademarkStart) {
		this.trademarkStart = trademarkStart;
	}

	public Date getTrademarkEnd() {
		return trademarkEnd;
	}

	public void setTrademarkEnd(Date trademarkEnd) {
		this.trademarkEnd = trademarkEnd;
	}

	public Integer getBrandStatus() {
		return brandStatus;
	}

	public void setBrandStatus(Integer brandStatus) {
		this.brandStatus = brandStatus;
	}

	public Long getSubmitAuditUserId() {
		return submitAuditUserId;
	}

	public void setSubmitAuditUserId(Long submitAuditUserId) {
		this.submitAuditUserId = submitAuditUserId;
	}

	// auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getCountryId() {
        return countryId;
    }

    public void setCountryId(Long countryId) {
        this.countryId = countryId;
    }

    public Integer getFileId() {
        return fileId;
    }

    public void setFileId(Integer fileId) {
        this.fileId = fileId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getIsOwn() {
        return isOwn;
    }

    public void setIsOwn(Integer isOwn) {
        this.isOwn = isOwn;
    }

}
