package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import com.thebeastshop.pegasus.merchandise.cond.OpProdSkuAttributeInfoCond;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeLineInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeRelationInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeRelationVO;

/**
 * 属性管理对外服务
 * @author Gary
 * @date 2017/04/24
 */
public interface OpProdSkuAttributeService {
	
	int addOrUpdateProdSkuAttribute(OpProdSkuAttributeInfo opProdSkuAttributeInfo);
	
	int approvalProdSkuAttribute(Integer attributeId, boolean isPass);
	
	int batchApprovalProdSkuAttribute(List<Integer> attributeIdList, boolean isPass);
	
	int associatedAttributes(String skuCode, List<Integer> attributeLineIds);
	
	List<OpProdSkuAttributeInfo> findByCond(OpProdSkuAttributeInfoCond cond);
	
	OpProdSkuAttributeInfo findInfoById(Integer id, boolean cascaded);
	
	List<OpProdSkuAttributeLineInfo> findLineByAttributeId(Integer attributeId); 
	
	List<String> findAttributeNameByCategoryId(Integer categoryId);
	
	int delAttributeById(Integer attributeId);
	/**
	 * 查询分类下的属性以及属性值
	 * @param categoryId
	 * @return
	 */
	List<OpProdSkuAttributeInfo> findAttributeAndLineByCategoryId(Integer categoryId, Integer lineStatus);
	
	/**
	 * 设置sku属性值
	 * @param skuCode
	 * @param attributeLineList
	 */
	void setupSkuAttribute (String skuCode, List<Integer> attributeLineList);
	
	/**
	 * 批量设置sku属性值
	 * @param relationList 设置的属性
	 * @param deleteRelationList  删除的属性
	 */
	void batchSetupSkuAttribute(List<OpProdSkuAttributeRelationVO> relationList, List<OpProdSkuAttributeRelationInfo> deleteRelationList);
	
	List<OpProdSkuAttributeRelationInfo> findAttributeLinesBySkuCode(String skuCode);
	
	List<OpProdSkuAttributeLineInfo> findAttributeValByCond(OpProdSkuAttributeInfoCond cond);
	
	void batchReleaseSkuAttribute(List<OpProdSkuAttributeRelationInfo> relationList);
	
	OpProdSkuAttributeInfo findRepeatAttribute(String attributeName, Integer categoryId);
	
	List<OpProdSkuAttributeLineInfo> findLineByAttributeIdAndStatus(Integer attributeId, Integer lineStatus);
	
	/**
	 * 删除属性后要释放对应的sku的关联关系
	 * @param attributeId
	 */
	void releaseRelationByAttributeId(Integer attributeId);
	
}
