package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.PcsSkuCompanyAttrEnum;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuInstallServiceEnum;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuProductTypeEnum;
import com.thebeastshop.pegasus.util.annotation.ObjectChangeLog;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import java.io.Serializable;
import java.math.BigDecimal;

@ExcelTemplate
@ExcelSheet(value = "sheet1")
public class PcsSkuConfigItemsDTO  implements Serializable {
    
    private static final long serialVersionUID = 6632179915157053134L;

    private Integer id;

    private String skuCode;


    @ExcelColumn(name="是否大家具")
    @ObjectChangeLog(name = "是否大家具")
    private Boolean whetherLogistics;

    @ObjectChangeLog(name = "平均物流运费（元）")
    private BigDecimal averageLogisticsCosts;

    @ExcelColumn(name="平均物流运费（元）")
    private Boolean whetherVirtual;

    @ObjectChangeLog(name = "安装服务")
    private String installServiceDesc;

    private Short installService;

    @ObjectChangeLog(name = "标签图片")
    private String supplierTagFile;

    //供应商自带标签文件是否为图片

    private boolean supplierTagFileWhetherImg = true;

    @ObjectChangeLog(name = "净重")
    private BigDecimal netWeight;

    @ObjectChangeLog(name = "用途")
    private String purpose;

    @ObjectChangeLog(name = "自进口申报要素")
    private String declareElement; //自进口申报要素

    @ObjectChangeLog(name = "Family")
    private String family;
    @ObjectChangeLog(name = "BU")
    private String bu;
    @ObjectChangeLog(name = "productDefination")
    private String productDefination;

    @ObjectChangeLog(name = "翻单交期")
    private Short turnoverDeliveryPeriod;
    @ObjectChangeLog(name = "颜色")
    private String color;

    @ObjectChangeLog(name = "长")
    private BigDecimal length;
    @ObjectChangeLog(name = "宽")
    private BigDecimal width;
    @ObjectChangeLog(name = "高")
    private BigDecimal heigth;

    @ObjectChangeLog(name = "内箱数量")
    private Integer innerboxQuantity;
    private Integer factory1;
    @ObjectChangeLog(name = "Factory 1")
    private String factory1Desc;
    private Integer factory2;
    @ObjectChangeLog(name = "Factory 2")
    private String factory2Desc;
    private Integer factory3;
    @ObjectChangeLog(name = "Factory 3")
    private String factory3Desc;

    //币种
    @ObjectChangeLog(name = "币种")
    private String currencyCode;
    private String oldCurrencyCode;

    //外币成本
    @ObjectChangeLog(name = "外币成本")
    private BigDecimal currencyCostPrice;

    @ExcelColumn(name="公司属性")
    private Integer companyAttr;

    @ObjectChangeLog(name = "公司属性")
    private String companyAttrName;

    private Short productType;
    @ObjectChangeLog(name = "商品类型")
    private String productTypeDesc;
    private Boolean fragile;

    public boolean getSupplierTagFileWhetherImg() {
        if (EmptyUtil.isNotEmpty(supplierTagFile) && supplierTagFile.indexOf(".pdf") != -1) {
            return  false;
        }
        return supplierTagFileWhetherImg;
    }

    public void setSupplierTagFileWhetherImg(boolean supplierTagFileWhetherImg) {
        this.supplierTagFileWhetherImg = supplierTagFileWhetherImg;
    }

    public Short getInstallService() {
        return installService;
    }

    public void setInstallService(Short installService) {
        this.installService = installService;
    }

    public String getSupplierTagFile() {
        return supplierTagFile;
    }

    public void setSupplierTagFile(String supplierTagFile) {
        this.supplierTagFile = supplierTagFile;
    }

    public Integer getId() {
        return id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.id
     *
     * @param id the value for t_pcs_sku_config_items.id
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_sku_config_items.sku_code
     *
     * @return the value of t_pcs_sku_config_items.sku_code
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public String getSkuCode() {
        return skuCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.sku_code
     *
     * @param skuCode the value for t_pcs_sku_config_items.sku_code
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode == null ? null : skuCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_sku_config_items.whether_logistics
     *
     * @return the value of t_pcs_sku_config_items.whether_logistics
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public Boolean getWhetherLogistics() {
        return whetherLogistics;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.whether_logistics
     *
     * @param whetherLogistics the value for t_pcs_sku_config_items.whether_logistics
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setWhetherLogistics(Boolean whetherLogistics) {
        this.whetherLogistics = whetherLogistics;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_sku_config_items.average_logistics_costs
     *
     * @return the value of t_pcs_sku_config_items.average_logistics_costs
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public BigDecimal getAverageLogisticsCosts() {
        return averageLogisticsCosts;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.average_logistics_costs
     *
     * @param averageLogisticsCosts the value for t_pcs_sku_config_items.average_logistics_costs
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setAverageLogisticsCosts(BigDecimal averageLogisticsCosts) {
        this.averageLogisticsCosts = averageLogisticsCosts;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_sku_config_items.whether_virtual
     *
     * @return the value of t_pcs_sku_config_items.whether_virtual
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public Boolean getWhetherVirtual() {
        return whetherVirtual;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.whether_virtual
     *
     * @param whetherVirtual the value for t_pcs_sku_config_items.whether_virtual
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setWhetherVirtual(Boolean whetherVirtual) {
        this.whetherVirtual = whetherVirtual;
    }

    public boolean isSupplierTagFileWhetherImg() {
        return supplierTagFileWhetherImg;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getDeclareElement() {
        return declareElement;
    }

    public void setDeclareElement(String declareElement) {
        this.declareElement = declareElement;
    }

    public Integer getCompanyAttr() {
        return companyAttr;
    }

    public void setCompanyAttr(Integer companyAttr) {
        this.companyAttr = companyAttr;
    }

    public String getFamily() {
        return family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }

    public String getProductDefination() {
        return productDefination;
    }

    public void setProductDefination(String productDefination) {
        this.productDefination = productDefination;
    }

    public Short getTurnoverDeliveryPeriod() {
        return turnoverDeliveryPeriod;
    }

    public void setTurnoverDeliveryPeriod(Short turnoverDeliveryPeriod) {
        this.turnoverDeliveryPeriod = turnoverDeliveryPeriod;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeigth() {
        return heigth;
    }

    public void setHeigth(BigDecimal heigth) {
        this.heigth = heigth;
    }

    public Integer getInnerboxQuantity() {
        return innerboxQuantity;
    }

    public void setInnerboxQuantity(Integer innerboxQuantity) {
        this.innerboxQuantity = innerboxQuantity;
    }

    public Integer getFactory1() {
        return factory1;
    }

    public void setFactory1(Integer factory1) {
        this.factory1 = factory1;
    }

    public Integer getFactory2() {
        return factory2;
    }

    public void setFactory2(Integer factory2) {
        this.factory2 = factory2;
    }

    public Integer getFactory3() {
        return factory3;
    }

    public void setFactory3(Integer factory3) {
        this.factory3 = factory3;
    }

    public String getFactory1Desc() {
        return factory1Desc;
    }

    public void setFactory1Desc(String factory1Desc) {
        this.factory1Desc = factory1Desc;
    }

    public String getFactory2Desc() {
        return factory2Desc;
    }

    public void setFactory2Desc(String factory2Desc) {
        this.factory2Desc = factory2Desc;
    }

    public String getFactory3Desc() {
        return factory3Desc;
    }

    public void setFactory3Desc(String factory3Desc) {
        this.factory3Desc = factory3Desc;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BigDecimal getCurrencyCostPrice() {
        return currencyCostPrice;
    }

    public void setCurrencyCostPrice(BigDecimal currencyCostPrice) {
        this.currencyCostPrice = currencyCostPrice;
    }

    public String getOldCurrencyCode() {
        return oldCurrencyCode;
    }

    public void setOldCurrencyCode(String oldCurrencyCode) {
        this.oldCurrencyCode = oldCurrencyCode;
    }

    public Boolean getFragile() {
        return fragile;
    }

    public void setFragile(Boolean fragile) {
        this.fragile = fragile;
    }

    public String getCompanyAttrName() {
      if (companyAttrName != null) {
        return companyAttrName;
      }
      return PcsSkuCompanyAttrEnum.getDesc(companyAttr);
    }

    public void setCompanyAttrName(String companyAttrName) {
        this.companyAttrName = companyAttrName;
    }

    public String getInstallServiceDesc() {
        if (installServiceDesc != null) {
          return installServiceDesc;
        }
        return installService == null ? "" : PcsSkuInstallServiceEnum.getDesc((int)installService);
    }

    public void setInstallServiceDesc(String installServiceDesc) {
        this.installServiceDesc = installServiceDesc;
    }

    public Short getProductType() {
        return productType;
    }

    public void setProductType(Short productType) {
        this.productType = productType;
    }

    public String getProductTypeDesc() {
        return productTypeDesc == null ? productType == null ? "" : PcsSkuProductTypeEnum.getDesc(productType) : productTypeDesc;
    }

    public void setProductTypeDesc(String productTypeDesc) {
        this.productTypeDesc = productTypeDesc;
    }
}